package Apache::Gramene;
# file Apache/Gramene.pm

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use GramenePage;

sub handler {
  my $r = shift;

  return DECLINED unless $r->content_type eq 'text/html';
  my $fh = Apache::File->new($r->filename) || return DECLINED;

  my $page = GramenePage->new($r);

  my $insert=$r->filename;
  $insert=~ s![^/]*$!top_insert.html!;
  my $ifh;
  if ( ( -r $insert) &&  ($ifh=Apache::File->new($insert)) ) {
    $insert=join '',<$ifh>;
  } else {
    $insert='';
  } 

  # This code handles the "If-Modified-Since" code.
  $r->update_mtime($page->modified);
  $r->set_last_modified;
  my $rc = $r->meets_conditions;
  return $rc unless $rc == OK;

  $r->send_http_header;
  return OK if $r->header_only;

  my ($header_found,$body_found,$body_ended);
  my $footer_text = qq(<p align="left">Last modified: ).localtime((stat($r->filename))[9]).qq(</p>);

  while (<$fh>) {

      if (m!(.*)(</head[^>]*>)(.*)!i) {
          $r->print($1);
          $r->print($page->stylesheet_link);
          $r->print($2);
	  $_=$3;
          $header_found++;
      }


      if (m!(.*)<body[^>]*>(.*)!i) {
	$r->print($1);
	$r->print($page->stylesheet,"</head>") unless $header_found;
	$r->print($page->start_body);
	$r->print($insert);
	$_=$2;
	$body_found++;
      }

      if (m!(.*)</body!i) {
	$r->print($1);
	$r->print($page->end_body($footer_text));
	$body_ended++;
	last;	#since end_body includes </html>
      }

      elsif (m!<h\d+>!i && !$body_found) { # oops, in body
	$r->print($page->stylesheet_link);
	$r->print($page->start_body);
	$r->print($insert);
	$r->print($_);
	$header_found++;
	$body_found++;
      }

      else {
#	s!http://probe\.nalusda\.gov:8000/otherdocs/rgn/rgn\d+/!!g;
	print $_;
      }

  }

  $r->print($page->end_body($footer_text)) unless $body_ended;
  return OK;
}

1;
__END__
