#!/usr/bin/perl

#-----------------------------------------------------
# $Id: make_feature_correspondences.pl,v 1.2 2002/03/12 02:04:56 kclark Exp $
#
# File       : fill_physical_map_table.pm
# Programmer : Ken Y. Clark, kclark@logsoft.com
# Created    : 2001/11/10
# Purpose    : 
#-----------------------------------------------------

use strict;
use IO::File;
use lib '/usr/local/apache/lib/perl';
use CSHL::ComparativeMaps::Constants;
use CSHL::DB;

use constant EVIDENCE_ID => 1;

use constant SELECT_FEATURE_ID_SQL => q[
    select feature_id
    from   cmap_feature
    where  upper(feature_name)=?
];

use constant INSERT_SQL => q[
    insert 
    into   cmap_feature_correspondence
           ( feature_id1, feature_id2, correspondence_evidence_id )
    values ( ?, ?, ? )
];

my $file = shift                             or die "Usage: $0 file";
my $fh   = IO::File->new( $file )            or die "Can't read $file: $!";
our $db  = CSHL::DB->new({DB_NAME=>DB_NAME}) or die "No db connection";

our %feature_ids = ();

print "Truncating feature_correspondence table.\n";
$db->do( 'truncate table cmap_feature_correspondence' );

while ( <$fh> ) {
    chomp;
    my ( $feature_name1, $feature_name2 ) = split;
    next if $feature_name1 eq $feature_name2;

    my $feature_id1 = get_feature_id( $feature_name1 );
    my $feature_id2 = get_feature_id( $feature_name2 );

    if ( $feature_id1 and $feature_id2 ) {
        print "Inserting $feature_name1 ($feature_id1), ",
              "$feature_name2 ($feature_id2)\n";

        insert_feature_alias( $feature_id1, $feature_id2 );
        insert_feature_alias( $feature_id2, $feature_id1 );
    }
}
$fh->close;

#my @marker_ids = map { $_->[0] } @{ 
#    $db->selectall_arrayref(
#        q[
#            select marker_id
#            from   marker
#        ]
#    )
#};
#
#insert_marker_alias( $_, $_ ) for @marker_ids;

print "Done\n";

# ----------------------------------------------
# Subroutines
#
sub insert_feature_alias {
    my ( $feature_id1, $feature_id2 ) = @_;

    return if $db->selectrow_array( 
        q[
            select count(*)
            from   cmap_feature_correspondence
            where  feature_id1=?
            and    feature_id2=?
        ],
        {}, ( $feature_id1, $feature_id2 )
    );

    $db->do( INSERT_SQL, {}, ( $feature_id1, $feature_id2, EVIDENCE_ID ) );
}

sub get_feature_id {
    my $feature_name = shift;
    my $feature_id   = $feature_ids{ $feature_name } ||
        $db->selectrow_array( SELECT_FEATURE_ID_SQL, {}, ( $feature_name ) );

    unless ( $feature_id ) {
        warn "Couldn't find id for $feature_name.\n" 
    }
    else {
        $feature_ids{ $feature_name } = $feature_id;
    }
    
    return $feature_ids{ $feature_name };
}
