#!/usr/bin/perl -w

=head1 Name

add_HELP.pl - makes an ace file to add the HELP field to all members of a class
that don't have them

=head1 Synopsis

For Gramene.

add_HELP.pl   database_path  class [ ... class ] >___.ace


=cut

use strict;

use Ace;
use Fcntl;
use Carp;



sub usage {
    print STDERR "usage:$0 Gramene_database_directory_or_port class [..class]\n";
    exit 1;
}



my $db=shift or usage();


#need to open database and get all Reference Ids without HELP

my $AceDB;
if ($db =~ /\D/) { 	#not all numeric => directory
    $AceDB = Ace->connect(-path=>$db) || croak("Couldn't open gramene database $db.");
} else {	#all numeric => port
    $AceDB = Ace->connect(-port=>$db) || croak("Couldn't open gramene database on port $db.");
}

my $class;
while($class=shift) {

my $rcursor=$AceDB->fetch_many($class => '*');

    while (my $ref=$rcursor->next) {
	my $r=$ref->at('HELP');
	$r or print qq($class : ),quote($ref),qq(\nHELP\t${class}_Help\n\n);
    }

}

sub quote {
    my $text=shift;
    $text or carp('quote') and return '';
    $text =~ s,([/"\\]),\\$1,g;
    return qq("$text");
}

