/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ZoomButtonControl
extends JPanel
implements ActionListener {
    private MapControl control = null;
    private MapRange map = null;
    private float extend;
    private float step;
    private Applet applet = null;

    public ZoomButtonControl() {
        this.buildUI();
    }

    public ZoomButtonControl(MapControl c) {
        this.buildUI();
        this.setMapControl(c);
    }

    public ZoomButtonControl(Applet a) {
        this.applet = a;
        this.buildUI();
    }

    public void setApplet(Applet a) {
        this.applet = a;
    }

    private void buildUI() {
        String sep = File.separator;
        String path = new String("jadex" + sep + "swing" + sep + "map" + sep);
        this.setLayout(new GridLayout(1, 4));
        ImageIcon icon1 = null;
        URL url = null;
        if (this.applet == null) {
            icon1 = new ImageIcon(path + "Up16.gif");
        } else {
            url = this.getClass().getResource("Up16.gif");
            icon1 = new ImageIcon(url);
        }
        JButton up = new JButton(icon1);
        up.setToolTipText("Click to move up the selected region in the chromosome");
        up.setPreferredSize(new Dimension(20, 20));
        up.setActionCommand("up");
        up.addActionListener(this);
        this.add(up);
        ImageIcon icon2 = null;
        if (this.applet == null) {
            icon2 = new ImageIcon(path + "ZoomIn16.gif");
        } else {
            url = this.getClass().getResource("ZoomIn16.gif");
            icon2 = new ImageIcon(url);
        }
        JButton zoomIn = new JButton(icon2);
        zoomIn.setToolTipText("Click to zoom in the selected region in the chromosome");
        zoomIn.setPreferredSize(new Dimension(20, 20));
        zoomIn.setActionCommand("zoomIn");
        zoomIn.addActionListener(this);
        this.add(zoomIn);
        ImageIcon icon3 = null;
        if (this.applet == null) {
            icon3 = new ImageIcon(path + "ZoomOut16.gif");
        } else {
            url = this.getClass().getResource("ZoomOut16.gif");
            icon3 = new ImageIcon(url);
        }
        JButton zoomOut = new JButton(icon3);
        zoomOut.setToolTipText("Click to zoom out the selected region in the chromosome");
        zoomOut.setPreferredSize(new Dimension(20, 20));
        zoomOut.setActionCommand("zoomOut");
        zoomOut.addActionListener(this);
        this.add(zoomOut);
        ImageIcon icon4 = null;
        if (this.applet == null) {
            icon4 = new ImageIcon(path + "Down16.gif");
        } else {
            url = this.getClass().getResource("Down16.gif");
            icon4 = new ImageIcon(url);
        }
        JButton down = new JButton(icon4);
        down.setToolTipText("Click to move down the selected region in the chromosome");
        down.setPreferredSize(new Dimension(20, 20));
        down.setActionCommand("down");
        down.addActionListener(this);
        this.add(down);
    }

    public void setMapControl(MapControl c) {
        this.control = c;
        try {
            this.map = c.getMap();
            this.extend = this.map.getExtendF();
            this.step = this.extend / 40.0f;
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("ButtonControl Panel");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ZoomButtonControl p = new ZoomButtonControl();
        f.getContentPane().add((Component)p, "Center");
        ((Component)f).setSize(100, 50);
        ((Component)f).setVisible(true);
    }

    public void actionPerformed(ActionEvent p1) {
        String command = p1.getActionCommand();
        MapRange current = this.control.getRange();
        try {
            float cStart = current.getStartF();
            float cEnd = current.getEndF();
            float step = current.getExtendF() / 3.0f;
            if (command.equalsIgnoreCase("up")) {
                if (cEnd == this.map.getEndF()) {
                    return;
                }
                cEnd += step;
                cStart += step;
                if (cEnd > this.map.getEndF()) {
                    cEnd = this.map.getEndF();
                }
            } else if (command.equalsIgnoreCase("down")) {
                if (cStart == this.map.getStartF()) {
                    return;
                }
                cEnd -= step;
                if ((cStart -= step) < this.map.getStartF()) {
                    cStart = this.map.getStartF();
                }
            } else if (command.equalsIgnoreCase("zoomIn")) {
                float step1;
                if ((cStart += (step1 = (cEnd - cStart) / 20.0f)) >= (cEnd -= step1)) {
                    cEnd += step1;
                    cStart -= step1;
                }
            } else if (command.equalsIgnoreCase("zoomOut")) {
                cStart -= step;
                cEnd += step;
                if (cStart < this.map.getStartF()) {
                    cStart = this.map.getStartF();
                }
                if (cEnd > this.map.getEndF()) {
                    cEnd = this.map.getEndF();
                }
            }
            MapRange range = new MapRange(cStart, cEnd);
            this.control.setRange(range);
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
    }
}

