/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class MiniMapCartoon
extends JPanel
implements PropertyChangeListener {
    private MapRange range = null;
    private MapRange map = null;
    private MapPoint[] marker = null;
    private float rel;

    public MiniMapCartoon(MapRange mapRange) {
        this.range = this.map = mapRange;
    }

    public MapPoint[] getMarker() {
        return this.marker;
    }

    public MapRange getRange() {
        return this.range;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        float f = (float)((Dimension2D)dimension).getWidth();
        float f2 = (float)((Dimension2D)dimension).getHeight();
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        graphics2D.setColor(Color.gray);
        graphics2D.fill(new RoundRectangle2D.Float(f / 3.0f, 1.0f, f / 3.0f, f2 - 2.0f, 5.0f, 5.0f));
        try {
            float f3;
            float f4;
            float f5 = (f2 - 2.0f) / this.map.getExtendF();
            float f6 = this.map.getEndF();
            graphics2D.setColor(Color.black);
            if (this.marker != null) {
                int n = 0;
                while (n < this.marker.length) {
                    f4 = (f6 - this.marker[n].getPosition()) * f5 + 1.0f;
                    graphics2D.draw(new Line2D.Float(f / 6.0f, f4, f / 3.0f, f4));
                    ++n;
                }
            }
            if ((f3 = f5 * this.range.getExtendF()) < 1.0f) {
                f3 = 1.0f;
            }
            f4 = (f6 - this.range.getEndF()) * f5 + 1.0f;
            graphics2D.setColor(Color.green);
            graphics2D.fill(new Rectangle2D.Float(f / 3.0f, f4, f / 3.0f, f3));
        }
        catch (UnknownPositionException unknownPositionException) {
            System.err.println(unknownPositionException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("range")) {
            MapRange mapRange = (MapRange)propertyChangeEvent.getNewValue();
            this.setRange(mapRange);
        }
    }

    public void setMarker(MapPoint[] mapPointArray) {
        this.marker = mapPointArray;
    }

    public void setRange(MapRange mapRange) {
        this.range = mapRange;
        this.repaint();
    }
}

