/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class MapScale1
extends JPanel
implements PropertyChangeListener {
    private MapRange range = null;
    private float extend;
    private float end;
    private int TOTAL_TICK = 10;

    public MapScale1() {
    }

    public MapScale1(MapRange mapRange) {
        this.setRange(mapRange);
    }

    public void setRange(MapRange mapRange) {
        this.range = mapRange;
        try {
            this.end = mapRange.getEndF();
            this.extend = mapRange.getExtendF();
            this.repaint();
        }
        catch (UnknownPositionException unknownPositionException) {
            System.out.println(mapRange.toStringF());
            System.out.println("Scale cannot be initialized: " + unknownPositionException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("range")) {
            MapRange mapRange = (MapRange)propertyChangeEvent.getNewValue();
            this.setRange(mapRange);
        }
    }

    public MapRange getRange() {
        return this.range;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        float f = (float)((Dimension2D)dimension).getWidth();
        float f2 = (float)((Dimension2D)dimension).getHeight();
        graphics2D.setColor(Color.white);
        graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Line2D.Float(f / 6.0f, 2.0f, f / 6.0f, f2 - 2.0f));
        float f3 = 2.0f;
        float f4 = (f2 - 4.0f) / (float)this.TOTAL_TICK;
        int n = 0;
        while (n <= this.TOTAL_TICK) {
            graphics2D.draw(new Line2D.Float(0.0f, f3, f / 3.0f, f3));
            float f5 = f3;
            int n2 = 0;
            while (n2 < 10) {
                graphics2D.draw(new Line2D.Float(f / 9.0f, f5 += f4 / 10.0f, 2.0f * f / 9.0f, f5));
                ++n2;
            }
            this.drawLabel(f / 3.0f, f3, graphics2D, n);
            f3 += f4;
            ++n;
        }
    }

    private void drawLabel(float f, float f2, Graphics2D graphics2D, int n) {
        float f3 = this.extend / (float)this.TOTAL_TICK;
        int n2 = (int)((this.end - (float)n * f3) * 100.0f);
        float f4 = (float)n2 / 100.0f;
        graphics2D.setFont(new Font("Dialog", 0, 9));
        graphics2D.drawString(f4 + "", f, f2 + 2.0f);
    }
}

