/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jade.db.AceAccessor;
import jade.db.AceObject;
import jade.db.JSAceAccessor;
import jadeSocket.ConnectPanel;
import jadex.swing.ObjectLabel;
import jadex.swing.classView.MapView;
import jadex.swing.map.HelpPane;
import jadex.swing.map.OpenFileAction;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class MapMenuBar
extends JMenuBar {
    private JInternalFrame frame = null;
    private JFrame f = null;
    private Font dFont = null;
    private MapView view = null;
    private AceAccessor accessor = null;
    private ConnectPanel connectP = null;
    private JCheckBox mk;
    private JCheckBox locator;
    private JCheckBox loci;
    private JCheckBox it;
    private JCheckBox scaleLeft;
    private JCheckBox scaleRight;
    private JMenu viewMenu = null;
    private JMenu helpMenu = null;
    private JMenu file = null;
    private boolean isApplet = false;
    private PropertyChangeListener connectProp = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase("buttonClicked")) {
                String host = MapMenuBar.this.connectP.getHost();
                int port = MapMenuBar.this.connectP.getPort();
                if (host != null && port != 0) {
                    JSAceAccessor accessor = new JSAceAccessor(host, port);
                    AceObject[] o = accessor.find("genetic_map", "*");
                    JPanel panel = new JPanel();
                    panel.setLayout(new GridLayout(3, 0));
                    int i = 0;
                    while (i < o.length) {
                        panel.add(new ObjectLabel(o[i]));
                        ++i;
                    }
                    JFrame f = new JFrame("Genetic_map: " + o.length);
                    panel.setBorder(BorderFactory.createEtchedBorder());
                    f.getContentPane().add((Component)panel, "Center");
                    ((Component)f).setSize(300, 200);
                    ((Component)f).setLocation(400, 400);
                    ((Component)f).setVisible(true);
                }
            }
        }
    };

    public MapMenuBar(JInternalFrame f) {
        this.frame = f;
        this.initialize();
    }

    public MapMenuBar(JFrame f) {
        this.f = f;
        this.initialize();
    }

    public MapMenuBar(MapView view) {
        this.f = view.getViewFrame();
        this.view = view;
        this.isApplet = view.isApplet();
        this.initialize();
    }

    private void initialize() {
        this.dFont = new Font("Dialog", 0, 11);
        if (!this.isApplet) {
            this.setFileMenu();
        }
        this.setViewMenu();
        this.setHelpMenu();
    }

    public MapView getMapView() {
        return this.view;
    }

    private void setFileMenu() {
        this.file = new JMenu("File");
        this.file.setFont(this.dFont);
        JMenuItem connect = new JMenuItem("Connect");
        connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapMenuBar.this.connectP = new ConnectPanel();
                MapMenuBar.this.connectP.hideUserAndPwd();
                JFrame f = new JFrame("Connect...");
                MapMenuBar.this.connectP.addPropertyChangeListener(new PropertyChangeListener(){
                    private final /* synthetic */ JFrame val$f;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$f = val$f;
                    }

                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equalsIgnoreCase("buttonClicked")) {
                            this.val$f.dispose();
                        }
                    }
                });
                MapMenuBar.this.connectP.addPropertyChangeListener(MapMenuBar.this.connectProp);
                f.setDefaultCloseOperation(2);
                ((Component)f).setSize(300, 200);
                f.getContentPane().add((Component)MapMenuBar.this.connectP, "Center");
                ((Component)f).setLocation(400, 400);
                ((Component)f).setVisible(true);
            }
        });
        connect.setFont(this.dFont);
        JMenuItem open = new JMenuItem("Open");
        open.setFont(this.dFont);
        open.addActionListener(new OpenFileAction(this.f, this.getMapView()));
        JMenuItem quit = new JMenuItem("close");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MapMenuBar.this.frame != null) {
                    MapMenuBar.this.frame.getContentPane().removeAll();
                    MapMenuBar.this.showFullMenu(false);
                    MapMenuBar.this.frame.validate();
                    MapMenuBar.this.frame.repaint();
                }
                if (MapMenuBar.this.f != null) {
                    MapMenuBar.this.f.getContentPane().removeAll();
                    MapMenuBar.this.showFullMenu(false);
                    MapMenuBar.this.f.validate();
                    MapMenuBar.this.f.repaint();
                    MapMenuBar.this.view.setTitle("Map View");
                }
            }
        });
        quit.setFont(this.dFont);
        this.file.add(connect);
        this.file.add(new JSeparator());
        this.file.add(open);
        this.file.add(new JSeparator());
        this.file.add(quit);
        this.add(this.file);
    }

    private void setViewMenu() {
        this.viewMenu = new JMenu("View");
        this.viewMenu.setFont(this.dFont);
        JMenu itemNumber = new JMenu("Item Number");
        itemNumber.setFont(this.dFont);
        JMenu items = new JMenu("Items");
        items.setFont(this.dFont);
        this.scaleLeft = new JCheckBox("Left Scale");
        this.scaleLeft.setActionCommand("sl");
        this.scaleLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapMenuBar.this.setShowingPanes(e);
            }
        });
        this.scaleLeft.setFont(this.dFont);
        this.scaleLeft.setSelected(true);
        this.scaleRight = new JCheckBox("Right Scale");
        this.scaleRight.setActionCommand("sr");
        this.scaleRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapMenuBar.this.setShowingPanes(e);
            }
        });
        this.scaleRight.setFont(this.dFont);
        this.scaleRight.setSelected(true);
        this.loci = new JCheckBox("Loci");
        this.loci.setActionCommand("loci");
        this.loci.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapMenuBar.this.setShowingPanes(e);
            }
        });
        this.loci.setFont(this.dFont);
        this.loci.setSelected(true);
        this.it = new JCheckBox("Interval (IT)");
        this.it.setActionCommand("it");
        this.it.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapMenuBar.this.setShowingPanes(e);
            }
        });
        this.it.setFont(this.dFont);
        this.it.setSelected(true);
        this.viewMenu.add(items);
        items.add(this.scaleLeft);
        items.add(this.scaleRight);
        items.add(this.it);
        items.add(this.loci);
        this.add(this.viewMenu);
    }

    public void showFullMenu(boolean show) {
        this.viewMenu.setVisible(show);
        this.helpMenu.setVisible(show);
    }

    private void setShowingPanes(ActionEvent e) {
        if (this.view != null) {
            String command = e.getActionCommand();
            if (command.equalsIgnoreCase("sl")) {
                if (this.scaleLeft.getSelectedObjects() != null) {
                    this.view.showLeftScale(true);
                } else {
                    this.view.showLeftScale(false);
                }
            } else if (command.equalsIgnoreCase("sr")) {
                if (this.scaleRight.getSelectedObjects() != null) {
                    this.view.showRightScale(true);
                } else {
                    this.view.showRightScale(false);
                }
            } else if (command.equalsIgnoreCase("loci")) {
                if (this.loci.getSelectedObjects() != null) {
                    this.view.showLocus(true);
                } else {
                    this.view.showLocus(false);
                }
            } else if (command.equalsIgnoreCase("it")) {
                if (this.it.getSelectedObjects() != null) {
                    this.view.showInterval(true);
                } else {
                    this.view.showInterval(false);
                }
            }
        }
    }

    private void setHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setFont(this.dFont);
        JMenuItem help = new JMenuItem("Help");
        help.setFont(this.dFont);
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Help");
                f.setDefaultCloseOperation(2);
                ((Component)f).setSize(400, 300);
                HelpPane h = new HelpPane(MapMenuBar.this.isApplet);
                h.setBorder(BorderFactory.createEtchedBorder());
                f.getContentPane().add((Component)new JScrollPane(h), "Center");
                ((Component)f).setVisible(true);
            }
        });
        this.helpMenu.add(help);
        this.add(this.helpMenu);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MenuBar Test");
        JInternalFrame f = new JInternalFrame(null, true, true, true, true);
        MapMenuBar bar = new MapMenuBar(f);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setJMenuBar(bar);
        ((Component)frame).setSize(400, 300);
        ((Component)frame).setVisible(true);
    }
}

