/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jade.db.AceObject;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MapCartoon
extends JPanel
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final float WIDTH = 10.0f;
    private float inX;
    private float inY;
    private float outX;
    private float outY;
    private float relInX;
    private float relInY;
    private float relOutX;
    private float relOutY;
    private float alpha = 1.0f;
    private AlphaComposite composite = null;
    private int rule = 5;
    private boolean start = true;
    private boolean dragging = false;
    private boolean inScale = false;
    private Shape drawing = null;
    private Shape cartoon = null;
    private boolean top = false;
    private boolean bottom = false;
    private boolean popup = false;
    private int popY;
    private float w;
    private float h;
    private AceObject[] mainLoci = null;
    private float paddingY = 2.0f;
    private long TOTAL_LENGTH_LONG = -1L;
    private float TOTAL_LENGTH_FLOAT = Float.POSITIVE_INFINITY;
    private MapControl control = null;
    private boolean debug = false;
    private MapRange range = new MapRange(0.0f, 0.0f);
    private MapRange map = null;
    private int count = 0;

    public MapCartoon() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTipText("Draw a rectangle around the bar for zooming.");
    }

    public MapCartoon(long length) {
        this();
        this.TOTAL_LENGTH_LONG = length;
    }

    public MapCartoon(float lengthF) {
        this();
        this.TOTAL_LENGTH_FLOAT = lengthF;
    }

    public MapCartoon(MapRange scale) {
        this();
        this.map = scale;
        this.range = scale;
        try {
            this.TOTAL_LENGTH_FLOAT = this.map.getExtendF();
        }
        catch (UnknownPositionException e) {
            System.out.println("Position unknown: " + e);
            return;
        }
    }

    public void setMapControl(MapControl c) {
        this.control = c;
    }

    public MapRange getMap() {
        return this.map;
    }

    public void setTotalLengthL(long length) {
        this.TOTAL_LENGTH_LONG = length;
    }

    public void setTotalLengthF(float lengthF) {
        this.TOTAL_LENGTH_FLOAT = lengthF;
    }

    public void setMainLoci(AceObject[] loci) {
        this.mainLoci = loci;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        this.w = (float)((Dimension2D)d).getWidth();
        this.h = (float)((Dimension2D)d).getHeight();
        BufferedImage buffImg = new BufferedImage((int)this.w, (int)this.h, 2);
        Graphics2D gbi = buffImg.createGraphics();
        g2.setPaint(Color.white);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, this.w, this.h));
        float rectX = (this.w - 10.0f) / 2.0f;
        float rectY = this.paddingY;
        gbi.setColor(Color.black);
        this.cartoon = new RoundRectangle2D.Float(rectX, rectY, 10.0f, this.h - 2.0f * this.paddingY, 5.0f, 5.0f);
        gbi.fill(this.cartoon);
        if (!this.start) {
            this.composite = AlphaComposite.getInstance(this.rule, this.alpha);
            gbi.setColor(Color.green);
            gbi.setComposite(this.composite);
            this.inX = this.relInX * this.w;
            this.outX = this.relOutX * this.w;
            this.inY = this.relInY * this.h;
            this.outY = this.relOutY * this.h;
            float hD = this.outY - this.inY > 1.0f ? this.outY - this.inY : 1.0f;
            this.drawing = new Rectangle2D.Float(this.inX, this.inY, this.outX - this.inX, hD);
            gbi.fill(this.drawing);
            this.setRange();
        }
        g2.drawImage(buffImg, null, 0, 0);
    }

    private void setRange() {
        float ratio = this.TOTAL_LENGTH_FLOAT / (this.h - 2.0f * this.paddingY);
        float end = 0.0f;
        float start = 0.0f;
        try {
            end = this.map.getEndF() - (this.inY - this.paddingY) * ratio;
            start = this.map.getEndF() - (this.outY - this.paddingY) * ratio;
        }
        catch (UnknownPositionException e) {
            // empty catch block
        }
        this.range = new MapRange(start, end);
        if (this.control != null) {
            this.control.setRange(this.range);
        }
    }

    public void setMapRange(MapRange r) {
        if (this.range.equalsF(r)) {
            return;
        }
        this.range = r;
        if (this.start) {
            this.start = false;
        }
        try {
            float rel = (this.h - 2.0f * this.paddingY) / this.map.getExtendF();
            float offset = this.map.getEndF();
            float height = rel * r.getExtendF();
            float startY = (offset - r.getEndF()) * rel + this.paddingY;
            float endY = startY + height;
            this.relInY = startY / this.h;
            this.relOutY = endY / this.h;
            this.relInX = (this.w - 10.0f - 5.0f) / (2.0f * this.w);
            this.relOutX = (this.w + 10.0f + 5.0f) / (2.0f * this.w);
            this.repaint();
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
    }

    public void mouseReleased(MouseEvent p1) {
        if (p1.isPopupTrigger() && !this.popup) {
            this.popY = p1.getY();
            this.popup = true;
            return;
        }
        if (this.dragging) {
            this.rule = 5;
            this.alpha = 1.0f;
            this.repaint();
            this.dragging = false;
            this.inScale = false;
            this.top = false;
            this.bottom = false;
            this.popup = false;
            return;
        }
        if (this.drawing != null && this.inScale) {
            this.alpha = 1.0f;
            this.rule = 5;
            this.repaint();
            return;
        }
    }

    public void mouseClicked(MouseEvent p1) {
    }

    public void mouseEntered(MouseEvent p1) {
    }

    public void mousePressed(MouseEvent p1) {
        if (p1.isPopupTrigger() && !this.popup) {
            this.popY = p1.getY();
            if (this.debug) {
                System.out.println("Popup on");
            }
            this.popup = true;
        }
        if (this.drawing != null && this.drawing.contains(p1.getX(), p1.getY())) {
            this.inScale = true;
            this.alpha = 0.5f;
            this.rule = 2;
            this.repaint();
            return;
        }
        this.start = false;
        this.inX = p1.getX();
        this.relInX = this.inX / this.w;
        this.inY = p1.getY();
        this.relInY = this.inY / this.h;
    }

    public void mouseExited(MouseEvent p1) {
    }

    public void mouseDragged(MouseEvent p1) {
        this.dragging = true;
        if (this.inScale) {
            if (Math.abs((float)p1.getY() - this.inY) < 2.0f) {
                this.top = true;
                this.bottom = false;
                return;
            }
            if (Math.abs((float)p1.getY() - this.outY) < 2.0f) {
                this.top = false;
                this.bottom = true;
                return;
            }
            if (this.popup) {
                this.inY += (float)(p1.getY() - this.popY);
                this.relInY = this.inY / this.h;
                this.outY += (float)(p1.getY() - this.popY);
                this.relOutY = this.outY / this.h;
                this.popY = p1.getY();
            } else if (this.top) {
                this.inY = p1.getY();
                this.relInY = this.inY / this.h;
            } else if (this.bottom) {
                this.outY = p1.getY();
                this.relOutY = this.outY / this.h;
            }
        } else {
            this.outX = p1.getX();
            this.relOutX = this.outX / this.w;
            this.outY = p1.getY();
            this.relOutY = this.outY / this.h;
        }
        this.alpha = 1.0f;
        this.rule = 7;
        this.repaint();
    }

    public void mouseMoved(MouseEvent p1) {
    }

    public MapRange getRange() {
        return this.range;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MapCartoon Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MapCartoon panel = new MapCartoon(new MapRange(-30.0f, 30.0f));
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("range")) {
                    MapRange r = (MapRange)e.getNewValue();
                    System.out.println(r.toStringF());
                }
            }
        };
        panel.addPropertyChangeListener(l);
        frame.getContentPane().add((Component)panel, "Center");
        ((Component)frame).setSize(200, 400);
        ((Component)frame).setVisible(true);
        panel.setMapRange(new MapRange(-3.5f, 20.0f));
    }

    public void propertyChange(PropertyChangeEvent p1) {
        if (p1.getPropertyName().equalsIgnoreCase("range")) {
            MapRange r = (MapRange)p1.getNewValue();
            if (r == this.range) {
                return;
            }
            this.setMapRange(r);
        }
    }
}

