/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusUI;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;

public class LocusPanel
extends JPanel {
    Vector loci = null;
    private float DIFF = 10.0f;
    private float REL = 5.0f;
    private MapRange range = null;
    private float extend;
    private float offset = 0.0f;

    public LocusPanel() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(40, 100));
        this.loci = new Vector();
    }

    public LocusPanel(MapRange mapRange) {
        this();
        this.setRange(mapRange);
    }

    public void setRange(MapRange mapRange) {
        this.range = mapRange;
        try {
            this.offset = this.range.getEndF();
            this.extend = this.range.getExtendF();
        }
        catch (UnknownPositionException unknownPositionException) {
            System.out.println("Cannot get scale");
        }
        this.repaint();
    }

    public void addLocus(LocusUI locusUI) {
        if (this.checkAdding(locusUI)) {
            this.loci.addElement(locusUI);
            this.add(locusUI);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        float f = (float)((Dimension2D)dimension).getWidth();
        float f2 = (float)((Dimension2D)dimension).getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, f, f2));
        LocusUI locusUI = null;
        float f3 = f2 / this.extend;
        int n = 0;
        while (n < this.loci.size()) {
            locusUI = (LocusUI)this.loci.elementAt(n);
            int n2 = (int)((this.offset - locusUI.getPosition()) * f3);
            locusUI.setBounds(0, n2, (int)f, 10);
            ++n;
        }
    }

    public boolean checkAdding(LocusUI locusUI) {
        boolean bl = true;
        LocusUI locusUI2 = null;
        int n = this.loci.size();
        float f = locusUI.getPosition();
        int n2 = 0;
        while (n2 < n) {
            locusUI2 = (LocusUI)this.loci.elementAt(n2);
            float f2 = Math.abs(locusUI2.getPosition() - f);
            if (f2 * this.REL <= this.DIFF) {
                return false;
            }
            ++n2;
        }
        return bl;
    }
}

