/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class LocusModel {
    private List loci = new ArrayList();
    private Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            MapPoint p1 = (MapPoint)o1;
            MapPoint p2 = (MapPoint)o2;
            Float pos1 = null;
            Float pos2 = null;
            try {
                pos1 = new Float(p1.getPosition());
                pos2 = new Float(p2.getPosition());
            }
            catch (UnknownPositionException e) {
                System.err.println(e);
            }
            return pos2.compareTo(pos1);
        }

        public boolean equals(Object o1, Object o2) {
            MapPoint p1 = (MapPoint)o1;
            MapPoint p2 = (MapPoint)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.equalsIgnoreCase(name2);
        }
    };

    public void addPoint(MapPoint p) {
        this.loci.add(p);
    }

    public void setData(Vector v) {
        this.loci = new ArrayList(v);
    }

    public void setData(List l) {
        this.loci = l;
    }

    public void setData(MapPoint[] points) {
        this.loci = Arrays.asList(points);
    }

    public MapPoint[] getData() {
        return this.loci.toArray(new MapPoint[0]);
    }

    public MapPoint[] getLociShown(int size) {
        ArrayList copy = new ArrayList(this.loci);
        List shown = copy.subList(0, size);
        return shown.toArray(new MapPoint[0]);
    }

    public MapPoint[] getLociShown(MapRange r) {
        ArrayList list = new ArrayList(this.loci);
        try {
            float start = r.getStartF();
            float end = r.getEndF();
            ListIterator i = list.listIterator();
            while (i.hasNext()) {
                MapPoint p = (MapPoint)i.next();
                float pos = p.getPosition();
                if (!(pos <= start) && !(pos >= end)) continue;
                i.remove();
            }
        }
        catch (UnknownPositionException e) {
            System.err.println(e);
        }
        return list.toArray(new MapPoint[0]);
    }

    public MapPoint[] getLociShown(MapRange r, int number) {
        MapPoint[] total = this.getLociShown(r);
        int size = total.length < number ? total.length : number;
        MapPoint[] rtn = new MapPoint[size];
        int i = 0;
        while (i < size) {
            rtn[i] = total[i];
            ++i;
        }
        return rtn;
    }

    public void setComparator(Comparator comp) {
        this.comp = comp;
    }

    public Comparator getComparator() {
        return this.comp;
    }

    public void sort() {
        Collections.sort(this.loci, this.comp);
    }

    public void sort(Comparator comp) {
        Collections.sort(this.loci, comp);
    }

    public void sort(MapPoint[] points, Comparator comp) {
        List<MapPoint> l = Arrays.asList(points);
        Collections.sort(l, comp);
    }

    public void sort(MapPoint[] points) {
        this.sort(points, this.comp);
    }

    public void sort(List points) {
        Collections.sort(points, this.comp);
    }
}

