/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusControl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LocusKnob
extends JPanel
implements MouseListener {
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_NO = 0;
    private int direction = 0;
    private final Dimension size = new Dimension(10, 10);
    private boolean mouseIn = false;
    private LocusControl control = null;

    public LocusKnob() {
        this.addMouseListener(this);
    }

    public LocusKnob(LocusControl c) {
        this.control = c;
        this.addMouseListener(this);
    }

    public void setLocusControl(LocusControl c) {
        this.control = c;
    }

    public LocusControl getLocusControl() {
        return this.control;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setDirection(int d) {
        if (d == this.direction) {
            return;
        }
        this.direction = d;
        String tip = null;
        switch (this.direction) {
            case 1: {
                tip = new String("Move up");
                break;
            }
            case 2: {
                tip = new String("Move down");
                break;
            }
            case 0: {
                tip = new String("No moving");
            }
        }
        this.setToolTipText(tip);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        g2.setPaint(Color.white);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        if (this.mouseIn) {
            g2.setPaint(Color.red);
        } else {
            g2.setPaint(Color.gray);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f, 0, 0));
        switch (this.direction) {
            case 0: {
                g2.fill(new Ellipse2D.Float(0.0f, 0.0f, w, h));
                break;
            }
            case 1: {
                g2.draw(new Line2D.Float(0.0f, h / 2.0f, w / 2.0f, 0.0f));
                g2.draw(new Line2D.Float(w / 2.0f, 0.0f, w, h / 2.0f));
                g2.draw(new Line2D.Float(w / 2.0f, 0.0f, w / 2.0f, h));
                break;
            }
            case 2: {
                g2.draw(new Line2D.Float(0.0f, h / 2.0f, w / 2.0f, h));
                g2.draw(new Line2D.Float(w / 2.0f, h, w, h / 2.0f));
                g2.draw(new Line2D.Float(w / 2.0f, h, w / 2.0f, 0.0f));
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        switch (this.direction) {
            case 1: {
                this.doMovingUp();
                break;
            }
            case 2: {
                this.doMovingDown();
                break;
            }
        }
    }

    private void doMovingUp() {
        this.control.movingUp();
    }

    private void doMovingDown() {
        this.control.movingDown();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("LocusKnob Testing");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel p = new JPanel();
        p.add(new LocusKnob());
        f.getContentPane().add((Component)p, "Center");
        ((Component)f).setSize(50, 50);
        ((Component)f).setVisible(true);
    }
}

