/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.AbstractMapPoint;
import jadex.swing.map.LocusControl;
import jadex.swing.map.LocusDisplayPopup;
import jadex.swing.map.LocusKnob;
import jadex.swing.map.LocusLayout;
import jadex.swing.map.LocusModel;
import jadex.swing.map.LocusShow;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.MiniMapCartoon;
import jadex.swing.map.SmartLocusLayout;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public class LocusDisplay
extends LocusShow
implements MouseListener,
MouseMotionListener {
    private MapRange range = null;
    private MapRange map = null;
    private LocusModel model = new LocusModel();
    private LocusControl control = null;
    private MapPoint[] loci = null;
    private MapPoint[] sTotal = null;
    private LocusUI[] lUI = null;
    private Vector points = new Vector();
    private final float REL = 6.0f;
    private float yPadding = 10.0f;
    private final float xPadding = 5.0f;
    private float rightP;
    private float offset;
    private float rel;
    private boolean cShown = true;
    private String mouseInName = null;
    private float inX;
    private float inY;
    private float outX;
    private float outY;
    private boolean doZooming = false;
    private Rectangle2D.Float zoom = new Rectangle2D.Float();
    private boolean cursorChanged = false;
    private JPopupMenu pop2 = null;
    private LocusKnob topKnob = null;
    private LocusKnob bottomKnob = null;
    private Color pColor = Color.orange;
    private Color vColor = Color.gray;
    private Color hColor = Color.black;
    private Color cColor = Color.lightGray;
    private Color bColor = Color.white;
    protected Color nColor = Color.black;
    protected Color highLightColor = Color.blue;
    private LocusLayout layout = null;
    private LocusLayout columnLayout = null;
    private LocusLayout smartLayout = null;
    private Cursor magnifier = null;
    private MiniMapCartoon mini = null;
    private int count = 0;

    protected LocusDisplay() {
        this.initialize();
    }

    public LocusDisplay(MapRange r) {
        this.map = r;
        this.range = r;
        this.control = new LocusControl(this);
        this.control.setMapRange(this.range);
        this.mini = new MiniMapCartoon(this.map);
        this.mini.setBorder(BorderFactory.createBevelBorder(1));
        this.initialize();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(1600, 400));
        this.setLayout(null);
        LocusDisplayPopup pop = new LocusDisplayPopup(this, this.control);
        this.setPopup(pop);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.columnLayout = new LocusLayout(this.yPadding, LocusControl.NUMBER_PER_COLUMN, this.cShown, this.cColor);
        this.smartLayout = new SmartLocusLayout(this.yPadding, LocusControl.NUMBER_PER_COLUMN, this.cShown, this.cColor);
        this.layout = this.columnLayout;
        this.setKnobs();
        this.magnifier = this.createCursor();
    }

    public void setModel(LocusModel m) {
        this.model = m;
        this.control.setModel(m);
        this.loci = this.model.getData();
        this.assignPoints(this.loci);
    }

    public LocusControl getLocusControl() {
        return this.control;
    }

    private Cursor createCursor() {
        Cursor c = null;
        c = Cursor.getPredefinedCursor(12);
        return c;
    }

    private void setKnobs() {
        this.topKnob = new LocusKnob();
        this.bottomKnob = new LocusKnob();
        this.control.setKnobs(this.topKnob, this.bottomKnob);
    }

    public void setPopup(JPopupMenu pop) {
        this.pop2 = pop;
    }

    public LocusDisplayPopup getPopup() {
        return (LocusDisplayPopup)this.pop2;
    }

    public void setLocusLayout(LocusLayout l) {
        this.layout = l;
        this.layout.setLocusUI(this.lUI);
        this.repaint();
    }

    public void setLocusLayout(String name) {
        if (name.equalsIgnoreCase("columnLayout")) {
            this.setLocusLayout(this.columnLayout);
        } else if (name.equalsIgnoreCase("smartLayout")) {
            this.setLocusLayout(this.smartLayout);
        }
    }

    public void setConnectShown(boolean b) {
        this.cShown = b;
        this.columnLayout.setConnect(b);
        this.smartLayout.setConnect(b);
        this.repaint();
    }

    public boolean isConnectShown() {
        return this.cShown;
    }

    protected void setRange(MapRange r) {
        this.range = r;
        if (this.mini != null) {
            this.mini.setRange(r);
        }
    }

    public LocusModel getModel() {
        return this.model;
    }

    protected void setLocusUI(LocusUI[] ui) {
        this.lUI = ui;
        this.removeAll();
        this.add(this.mini);
        this.mini.setBounds(0, 0, 20, 60);
        if (this.lUI != null && this.lUI.length > 0) {
            int i = 0;
            while (i < this.lUI.length) {
                this.add(this.lUI[i]);
                this.lUI[i].setBounds(0, 0, 40, 10);
                this.lUI[i].addMouseListener(new LineMouse(this.lUI[i], this));
                ++i;
            }
        }
        this.layout.setLocusUI(this.lUI);
    }

    protected void setTotalLocus(MapPoint[] t) {
        this.sTotal = t;
    }

    private void assignPoints(MapPoint[] l) {
        Vector<MapPoint> left = new Vector<MapPoint>();
        Vector<MapPoint> added = new Vector<MapPoint>();
        float pos = Float.MAX_VALUE;
        int i = 0;
        while (i < l.length) {
            try {
                pos = l[i].getPosition();
            }
            catch (UnknownPositionException e) {
                System.err.println(e);
            }
            if (this.checkAdding(added, pos)) {
                added.addElement(l[i]);
            } else {
                left.addElement(l[i]);
            }
            ++i;
        }
        this.points.addElement(added);
        if (left.size() == 0) {
            return;
        }
        int size = left.size();
        MapPoint[] p = new MapPoint[size];
        int i2 = 0;
        while (i2 < size) {
            p[i2] = (MapPoint)left.elementAt(i2);
            ++i2;
        }
        this.assignPoints(p);
    }

    private boolean checkAdding(Vector p, float pos) {
        int size = p.size();
        MapPoint point = null;
        int i = 0;
        while (i < size) {
            point = (MapPoint)p.elementAt(i);
            float position = Float.MAX_VALUE;
            try {
                position = point.getPosition();
            }
            catch (UnknownPositionException e) {
                System.out.println(e);
            }
            float diff = Math.abs((pos - position) * 6.0f);
            if (diff <= 2.5f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        try {
            this.rel = (h - 2.0f * this.yPadding) / this.range.getExtendF();
            this.offset = this.range.getEndF();
        }
        catch (UnknownPositionException e) {
            System.out.println(e);
        }
        g2.setColor(this.bColor);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        if (this.points.size() != 0) {
            this.rightP = this.drawPoints(g2, h);
        }
        float x = this.rightP + 5.0f;
        g2.setColor(this.vColor);
        g2.draw(new Line2D.Float(x, this.yPadding, x, h - this.yPadding));
        this.add(this.topKnob);
        this.topKnob.setBounds((int)(x - 4.0f), (int)(this.yPadding - 8.0f), 8, 8);
        this.add(this.bottomKnob);
        this.bottomKnob.setBounds((int)(x - 4.0f), (int)(h - this.yPadding), 8, 8);
        g2.setColor(this.hColor);
        if (this.sTotal != null) {
            int i = 0;
            while (i < this.sTotal.length) {
                try {
                    float pos = this.sTotal[i].getPosition();
                    float y = (this.offset - pos) * this.rel + this.yPadding;
                    g2.draw(new Line2D.Float(x - 5.0f, y, x + 5.0f, y));
                }
                catch (UnknownPositionException e) {
                    System.err.println(e);
                }
                ++i;
            }
        }
        this.layout.drawNames(x += 15.0f, h, this.offset, this.rel, g2);
        if (this.doZooming) {
            g2.setPaint(Color.blue);
            g2.draw(this.zoom);
        }
    }

    private float drawPoints(Graphics2D g2, float h) {
        int size = this.points.size();
        float x = 5.0f;
        g2.setColor(this.pColor);
        int i = size - 1;
        while (i >= 0) {
            Vector v = (Vector)this.points.elementAt(i);
            int size1 = v.size();
            int j = 0;
            while (j < size1) {
                try {
                    MapPoint p = (MapPoint)v.elementAt(j);
                    float pos = p.getPosition();
                    float y = (this.offset - pos) * this.rel + this.yPadding;
                    if (!(y < this.yPadding) && !(y > h - this.yPadding)) {
                        g2.draw(new Ellipse2D.Float(x - 1.0f, y - 1.0f, 2.0f, 2.0f));
                    }
                }
                catch (UnknownPositionException e) {
                    System.err.println(e);
                }
                ++j;
            }
            x += 3.0f;
            --i;
        }
        return x;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.doZooming) {
            this.doZooming = false;
            if (this.zoom.contains(e.getPoint()) && this.outX > this.rightP + 5.0f) {
                this.doZooming();
            } else {
                this.repaint();
            }
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    private void doPopup(MouseEvent e) {
        this.pop2.show(this, e.getX(), e.getY());
    }

    public void doSearch(String pattern) {
        if (this.control != null) {
            this.control.doSearch(pattern);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.doZooming) {
            if ((float)e.getX() > this.rightP + 5.0f) {
                return;
            }
            this.inX = e.getX();
            this.inY = e.getY();
            this.doZooming = true;
            return;
        }
        this.outX = e.getX();
        this.outY = e.getY();
        this.zoom.setRect(this.inX, this.inY, this.outX - this.inX, this.outY - this.inY);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.doZooming) {
            if (this.zoom.contains(e.getPoint()) && this.outX > this.rightP + 5.0f) {
                if (!this.cursorChanged) {
                    this.setCursor(this.magnifier);
                    this.cursorChanged = true;
                }
            } else if (this.cursorChanged) {
                this.setCursor(Cursor.getDefaultCursor());
                this.cursorChanged = false;
            }
        }
    }

    public void doZooming() {
        float start = this.offset - (this.outY - this.yPadding) / this.rel;
        float end = this.offset - (this.inY - this.yPadding) / this.rel;
        MapRange r1 = new MapRange(start, end);
        if (this.control != null) {
            this.control.zoom(r1);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.cursorChanged = false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Locus Display");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MapRange r = new MapRange(-30.0f, 30.0f);
        MapPoint[] p = new AbstractMapPoint[20];
        int i = 0;
        while (i < 6) {
            p[i] = new AbstractMapPoint("Point" + i, 5.0f);
            ++i;
        }
        int i2 = 6;
        while (i2 < 12) {
            p[i2] = new AbstractMapPoint("Point" + i2, 13.0f);
            ++i2;
        }
        int i3 = 12;
        while (i3 < 18) {
            p[i3] = new AbstractMapPoint("Point" + i3, -3.9f);
            ++i3;
        }
        p[18] = new AbstractMapPoint("Point18", -4.5f);
        p[19] = new AbstractMapPoint("Point19", 8.9f);
        LocusModel m = new LocusModel();
        m.setData(p);
        LocusDisplay display = new LocusDisplay(r);
        display.setModel(m);
        f.getContentPane().add((Component)display, "Center");
        ((Component)f).setSize(300, 500);
        ((Component)f).setVisible(true);
    }

    private class LineMouse
    extends MouseAdapter {
        LocusUI ui = null;
        LocusDisplay display = null;

        LineMouse(LocusUI ui, LocusDisplay display) {
            this.ui = ui;
            this.display = display;
        }

        public void mouseEntered(MouseEvent e) {
            LocusDisplay.this.mouseInName = this.ui.getName();
            LocusDisplay.this.layout.setMouseInName(LocusDisplay.this.mouseInName);
            this.display.repaint();
        }

        public void mouseExited(MouseEvent e) {
            LocusDisplay.this.mouseInName = null;
            LocusDisplay.this.layout.setMouseInName(null);
            this.display.repaint();
        }
    }
}

