/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusDisplay;
import jadex.swing.map.LocusKnob;
import jadex.swing.map.LocusModel;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

public class LocusControl
implements PropertyChangeListener {
    public static int NUMBER_PER_COLUMN = 20;
    private LocusModel model;
    private LocusDisplay display;
    private MapControl control;
    private MapRange map;
    private MapRange range;
    private int showNumber = NUMBER_PER_COLUMN;
    private MapPoint[] tPoints;
    private MapPoint[] sPoints;
    private LocusUI[] sLoci;
    private LocusKnob topKnob = null;
    private LocusKnob bottomKnob = null;
    private String pattern = null;

    public LocusControl() {
    }

    public LocusControl(LocusModel m) {
        this.setModel(m);
    }

    public LocusControl(LocusDisplay d) {
        this.setDisplay(d);
    }

    public LocusControl(LocusModel m, LocusDisplay d) {
        this.setModel(m);
        this.setDisplay(d);
    }

    public void setKnobs(LocusKnob top, LocusKnob bottom) {
        this.topKnob = top;
        this.bottomKnob = bottom;
        this.topKnob.setLocusControl(this);
        this.bottomKnob.setLocusControl(this);
    }

    public void setModel(LocusModel m) {
        this.model = m;
        this.tPoints = this.model.getLociShown(this.range);
        this.setLocusUI();
    }

    public LocusModel getModel() {
        return this.model;
    }

    public void setDisplay(LocusDisplay d) {
        this.display = d;
    }

    public LocusDisplay getDisplay() {
        return this.display;
    }

    public void setMapControl(MapControl c) {
        this.control = c;
        this.range = this.map = this.control.getMap();
    }

    public MapControl getMapControl() {
        return this.control;
    }

    public void updateUI() {
        if (this.display != null) {
            this.display.setLocusUI(this.sLoci);
            this.display.setTotalLocus(this.tPoints);
            this.display.repaint();
            if (this.display.getPopup() != null) {
                this.display.getPopup().checkShowMenu();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equalsIgnoreCase("range")) {
            MapRange r = (MapRange)e.getNewValue();
            this.setMapRange(r);
        }
    }

    public void zoom(MapRange r) {
        if (this.control != null) {
            this.control.setRange(r);
        } else {
            this.setMapRange(r);
        }
    }

    public void setMapRange(MapRange r) {
        if (this.range != null && this.range.equalsF(r)) {
            return;
        }
        if (this.map == null) {
            this.map = r;
        }
        this.range = r;
        if (this.topKnob != null) {
            this.checkKnobs();
        }
        this.display.setRange(r);
        if (this.model == null) {
            return;
        }
        this.tPoints = this.model.getLociShown(r);
        this.setLocusUI();
    }

    private void setLocusUI() {
        int size = this.showNumber > this.tPoints.length ? this.tPoints.length : this.showNumber;
        this.sPoints = new MapPoint[size];
        this.sLoci = new LocusUI[size];
        int i = 0;
        while (i < size) {
            this.sPoints[i] = this.tPoints[i];
            this.sLoci[i] = new LocusUI(this.tPoints[i]);
            ++i;
        }
        if (this.pattern != null) {
            this.doSearch(this.pattern);
        } else {
            this.updateUI();
        }
    }

    public int getTotalShowNumber() {
        if (this.tPoints != null) {
            return this.tPoints.length;
        }
        return 0;
    }

    public int getShowNumber() {
        if (this.sLoci != null) {
            return this.sLoci.length;
        }
        return 0;
    }

    public void reset() {
        if (this.control != null) {
            this.control.reset();
        }
    }

    public void showMore() {
        this.setShowNumber(this.showNumber + NUMBER_PER_COLUMN);
    }

    public void showLess() {
        int size = this.showNumber - NUMBER_PER_COLUMN;
        if (size < 0) {
            size = 0;
        }
        this.setShowNumber(size);
    }

    public void showReset() {
        this.setShowNumber(NUMBER_PER_COLUMN);
    }

    public void setShowNumber(int number) {
        this.showNumber = number;
        this.setLocusUI();
    }

    public void doSearch(String pattern) {
        this.pattern = pattern;
        if (this.sLoci != null && this.sLoci.length > 0) {
            int i = 0;
            while (i < this.sLoci.length) {
                String name1 = this.sLoci[i].getName();
                if (name1.indexOf(pattern) > -1) {
                    this.sLoci[i].setForeOutColor(this.display.highLightColor);
                }
                ++i;
            }
        }
        if (this.sLoci.length < this.tPoints.length) {
            Vector<MapPoint> shown = new Vector<MapPoint>(Arrays.asList(this.sPoints));
            Vector<MapPoint> totalP = new Vector<MapPoint>(Arrays.asList(this.tPoints));
            try {
                totalP.removeAll(shown);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("LocusControl: " + e);
            }
            Vector<MapPoint> sP = new Vector<MapPoint>(Arrays.asList(this.sPoints));
            Vector<LocusUI> sL = new Vector<LocusUI>(Arrays.asList(this.sLoci));
            Iterator i = totalP.iterator();
            while (i.hasNext()) {
                MapPoint p = (MapPoint)i.next();
                String name = p.getName();
                if (name.indexOf(pattern) <= -1) continue;
                sP.add(p);
                LocusUI ui = new LocusUI(p);
                ui.setForeOutColor(this.display.highLightColor);
                sL.add(ui);
            }
            this.sPoints = sP.toArray(new MapPoint[0]);
            this.sLoci = sL.toArray(new LocusUI[0]);
        }
        this.updateUI();
    }

    public void deSearch() {
        if (this.pattern == null) {
            return;
        }
        this.pattern = null;
        if (this.sLoci != null && this.sLoci.length > 0) {
            int i = 0;
            while (i < this.sLoci.length) {
                this.sLoci[i].setForeOutColor(this.display.nColor);
                ++i;
            }
        }
        this.updateUI();
    }

    public void movingUp() {
        this.control.movingUp();
    }

    public void movingDown() {
        this.control.movingDown();
    }

    public void checkKnobs() {
        if (this.map != null && this.range != null) {
            try {
                if (this.range.getStartF() > this.map.getStartF()) {
                    this.bottomKnob.setDirection(2);
                } else {
                    this.bottomKnob.setDirection(0);
                }
                if (this.range.getEndF() < this.map.getEndF()) {
                    this.topKnob.setDirection(1);
                } else {
                    this.topKnob.setDirection(0);
                }
            }
            catch (UnknownPositionException e) {
                System.err.println(e);
            }
        }
    }
}

