/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.LocusModel;
import jadex.swing.map.LocusPanel;
import jadex.swing.map.LocusShow;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.MapScale1;
import jadex.swing.map.MapZoom;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;

public class LocusContainer
extends LocusShow
implements PropertyChangeListener,
MouseListener,
MapZoom {
    private Vector panels = null;
    private MapRange range = null;
    private JPopupMenu popup = null;
    private LocusModel model = null;
    private boolean debug = false;

    public LocusContainer() {
        this.initialize();
    }

    public LocusContainer(MapRange mapRange) {
        this.range = mapRange;
        this.initialize();
    }

    public void setModel(LocusModel locusModel) {
        this.model = locusModel;
        this.removeAll();
        MapPoint[] mapPointArray = this.model.getData();
        int n = 0;
        while (n < mapPointArray.length) {
            this.addPoint(mapPointArray[n]);
            ++n;
        }
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    private void initialize() {
        this.addMouseListener(this);
        this.setLayout(new GridLayout(1, 0));
        LocusPanel locusPanel = new LocusPanel(this.range);
        this.panels = new Vector();
        this.addLocusPanel(locusPanel);
        ToolTipManager.sharedInstance().setInitialDelay(100);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        ToolTipManager.sharedInstance().setReshowDelay(500);
    }

    public void addLocusPanel(LocusPanel locusPanel) {
        this.panels.addElement(locusPanel);
        this.add(locusPanel);
    }

    public void horizontalZoom(int n) {
        int n2 = this.panels.size();
        int n3 = 0;
        while (n3 < n2) {
            LocusPanel locusPanel = (LocusPanel)this.panels.elementAt(n3);
            locusPanel.setPreferredSize(new Dimension(locusPanel.getWidth() + n, 500));
            ++n3;
        }
        this.doLayout();
        this.invalidate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("range")) {
            if (this.debug) {
                System.out.println("Range property has been changed.");
            }
            this.range = (MapRange)propertyChangeEvent.getNewValue();
            this.setRange(this.range);
        }
    }

    public void setRange(MapRange mapRange) {
        int n = this.panels.size();
        int n2 = 0;
        while (n2 < n) {
            LocusPanel locusPanel = (LocusPanel)this.panels.elementAt(n2);
            locusPanel.setRange(this.range);
            ++n2;
        }
    }

    public void addPoint(MapPoint mapPoint) {
        LocusUI locusUI = new LocusUI(mapPoint);
        this.addLocus(locusUI);
    }

    protected boolean addLocus(LocusUI locusUI) {
        LocusPanel locusPanel = null;
        boolean bl = false;
        int n = 0;
        int n2 = this.panels.size();
        while (n < n2) {
            locusPanel = (LocusPanel)this.panels.elementAt(n);
            if (locusPanel.checkAdding(locusUI)) {
                locusPanel.addLocus(locusUI);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            locusPanel = new LocusPanel(this.range);
            locusPanel.addLocus(locusUI);
            this.addLocusPanel(locusPanel);
            bl = true;
        }
        this.invalidate();
        return bl;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("LocusPanel Test");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        MapRange mapRange = new MapRange(-25.0f, 30.0f);
        LocusContainer locusContainer = new LocusContainer(mapRange);
        LocusUI locusUI = new LocusUI("Locus1", 2.0f);
        locusContainer.addLocus(locusUI);
        LocusUI locusUI2 = new LocusUI("Locus2", 13.0f);
        LocusUI locusUI3 = new LocusUI("Locus3", 25.0f);
        LocusUI locusUI4 = new LocusUI("Locus4", 2.5f);
        LocusUI locusUI5 = new LocusUI("Locus5", 2.3f);
        locusContainer.addLocus(locusUI2);
        locusContainer.addLocus(locusUI3);
        locusContainer.addLocus(locusUI4);
        locusContainer.addLocus(locusUI5);
        MapScale1 mapScale1 = new MapScale1();
        mapScale1.setPreferredSize(new Dimension(50, 400));
        mapScale1.setRange(mapRange);
        mapScale1.setBorder(BorderFactory.createEtchedBorder());
        locusContainer.setBorder(BorderFactory.createEtchedBorder());
        jFrame.getContentPane().add((Component)new JScrollPane(locusContainer), "Center");
        jFrame.getContentPane().add((Component)mapScale1, "West");
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void verticalZoom(int n) {
    }
}

