/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.map;

import jadex.swing.map.IntervalPanel;
import jadex.swing.map.IntervalUI;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapRange;
import jadex.swing.map.MapZoom;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;

public class IntervalContainer
extends JPanel
implements PropertyChangeListener,
MouseListener,
MapZoom {
    private Vector panels = null;
    private Vector intervals = null;
    private float extend = 0.0f;
    private MapRange range = null;
    private JPopupMenu popup = null;
    private MapControl control = null;

    public IntervalContainer() {
        this.initialize();
    }

    public IntervalContainer(MapRange scale) {
        this.range = scale;
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(this);
        this.setLayout(new GridLayout(1, 0));
        IntervalPanel p = new IntervalPanel(this.range);
        this.panels = new Vector();
        this.intervals = new Vector();
        this.addIntervalPanel(p);
        ToolTipManager.sharedInstance().setInitialDelay(100);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        ToolTipManager.sharedInstance().setReshowDelay(500);
        this.setPopup();
    }

    private void setPopup() {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem zoomOut = new JMenuItem("Zoom Out");
        zoomOut.setFont(new Font("Dialog", 0, 11));
        ActionListener a1 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IntervalContainer.this.control != null) {
                    IntervalContainer.this.control.reset();
                }
            }
        };
        zoomOut.addActionListener(a1);
        JMenuItem clear = new JMenuItem("Deselect");
        clear.setFont(new Font("Dialog", 0, 11));
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int size = IntervalContainer.this.panels.size();
                IntervalPanel p = null;
                int i = 0;
                while (i < size) {
                    p = (IntervalPanel)IntervalContainer.this.panels.elementAt(i);
                    p.resetBackground();
                    ++i;
                }
            }
        });
        JMenuItem search = new JMenuItem("Search");
        search.setFont(new Font("Dialog", 0, 11));
        search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String str = JOptionPane.showInputDialog(IntervalContainer.this, "Search for ...", "Interval Search", 1);
                if (str != null && str.length() != 0) {
                    IntervalContainer.this.doSearch(str);
                }
            }
        });
        pop.add(zoomOut);
        pop.add(new JSeparator());
        pop.add(clear);
        pop.add(new JSeparator());
        pop.add(search);
        this.setPopup(pop);
    }

    public void doSearch(String s) {
        int size = this.intervals.size();
        IntervalUI ui = null;
        String name = null;
        String str = s.toLowerCase();
        int i = 0;
        while (i < size) {
            ui = (IntervalUI)this.intervals.elementAt(i);
            name = ui.getName().toLowerCase();
            if (name.indexOf(s) > -1) {
                ui.setBackground(Color.yellow);
            }
            ++i;
        }
    }

    public void setPopup(JPopupMenu pop) {
        this.popup = pop;
    }

    public void addIntervalPanel(IntervalPanel p) {
        this.panels.addElement(p);
        this.add(p);
    }

    public boolean addInterval(IntervalUI intervalUI) {
        this.intervals.add(intervalUI);
        IntervalPanel p = null;
        boolean added = false;
        int i = 0;
        int size = this.panels.size();
        while (i < size) {
            p = (IntervalPanel)this.panels.elementAt(i);
            if (p.checkAdding(intervalUI)) {
                p.addInterval(intervalUI);
                added = true;
                break;
            }
            ++i;
        }
        if (!added) {
            p = new IntervalPanel(this.range);
            p.addInterval(intervalUI);
            this.addIntervalPanel(p);
            added = true;
        }
        return added;
    }

    public void propertyChange(PropertyChangeEvent p1) {
        if (p1.getPropertyName().equalsIgnoreCase("range")) {
            MapRange r = (MapRange)p1.getNewValue();
            int size = this.panels.size();
            int i = 0;
            while (i < size) {
                IntervalPanel p = (IntervalPanel)this.panels.elementAt(i);
                p.setRange(r);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("IntervalContainer Test");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        IntervalContainer intervals = new IntervalContainer(new MapRange(0.0f, 50.0f));
        IntervalUI i1 = new IntervalUI(2.0f, 20.0f, "Interval1");
        IntervalUI i2 = new IntervalUI(21.3f, 35.0f, "Interval2");
        IntervalUI i3 = new IntervalUI(10.0f, 25.9f, "Interval3");
        IntervalUI i4 = new IntervalUI(40.0f, 50.0f, "Interval4");
        IntervalUI i5 = new IntervalUI(45.0f, 50.0f, "Interval5");
        intervals.addInterval(i1);
        intervals.addInterval(i2);
        intervals.addInterval(i3);
        intervals.addInterval(i4);
        intervals.addInterval(i5);
        f.getContentPane().add((Component)intervals, "Center");
        ((Component)f).setSize(150, 200);
        ((Component)f).setVisible(true);
    }

    public void mouseReleased(MouseEvent p1) {
        if (p1.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, p1.getX(), p1.getY());
        }
    }

    public void mouseClicked(MouseEvent p1) {
    }

    public void mouseEntered(MouseEvent p1) {
    }

    public void mousePressed(MouseEvent p1) {
        if (p1.isPopupTrigger() && this.popup != null) {
            this.popup.show(this, p1.getX(), p1.getY());
        }
    }

    public void mouseExited(MouseEvent p1) {
    }

    public void horizontalZoom(int step) {
        int size = this.panels.size();
        int i = 0;
        while (i < size) {
            IntervalPanel p = (IntervalPanel)this.panels.elementAt(i);
            p.setSize(new Dimension(p.getWidth() + step, 500));
            ++i;
        }
        this.doLayout();
        this.invalidate();
    }

    public void verticalZoom(int step) {
    }

    public void setMapControl(MapControl c) {
        this.control = c;
        IntervalPanel p = null;
        int i = 0;
        while (i < this.panels.size()) {
            p = (IntervalPanel)this.panels.elementAt(i);
            p.setMapControl(c);
            ++i;
        }
    }
}

