/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.classView;

import jade.db.AceObject;
import jadex.swing.OpenFrames;
import jadex.swing.classView.ClassView;
import jadex.swing.map.IntervalContainer;
import jadex.swing.map.IntervalUI;
import jadex.swing.map.Locus;
import jadex.swing.map.LocusContainer;
import jadex.swing.map.LocusDisplay;
import jadex.swing.map.LocusModel;
import jadex.swing.map.LocusPanel;
import jadex.swing.map.LocusShow;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapCartoon;
import jadex.swing.map.MapControl;
import jadex.swing.map.MapMenuBar;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.MapScale1;
import jadex.swing.map.MapZoom;
import jadex.swing.map.RangeControlPanel;
import jadex.swing.map.ZoomPopupMenu;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class MapView
extends ClassView {
    private AceObject map = null;
    private JComponent view = null;
    private MapRange range = new MapRange(-30.0f, 30.0f);
    private JFrame f = null;
    private String title = new String("Map View: ");
    private boolean debug = false;
    private LocusShow lc = null;
    private JPanel lcPanel = null;
    private IntervalContainer ic = null;
    private JPanel itPanel = null;
    private JSplitPane split = null;
    private LocusPanel marker = null;
    private JPanel markerPanel = null;
    private JPanel solid1 = null;
    private MapCartoon locator = null;
    private JPanel locatorPanel = null;
    private JPanel scalePane1;
    private JPanel scalePane2;
    private RangeControlPanel rangeControl = null;
    private MapControl control = null;
    private MapMenuBar menubar = null;
    private boolean isApplet = false;
    private Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            Float e2;
            MapPoint p1 = (MapPoint)o1;
            MapPoint p2 = (MapPoint)o2;
            String n1 = p1.getName();
            String n2 = p2.getName();
            Float e1 = new Float(p1.getError());
            int rtn = e1.compareTo(e2 = new Float(p2.getError()));
            return rtn != 0 ? rtn : n1.compareTo(n2);
        }

        public boolean equals(Object o1, Object o2) {
            MapPoint p1 = (MapPoint)o1;
            MapPoint p2 = (MapPoint)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.equalsIgnoreCase(name2);
        }
    };

    public MapView() {
        this.initialize();
    }

    public MapView(AceObject o) throws ClassCastException {
        this.initialize();
        this.setObject(o);
    }

    public MapView(AceObject o, Applet a) throws ClassCastException {
        OpenFrames.getInstance().setApplet(a);
        this.rangeControl = new RangeControlPanel(a);
        this.isApplet = true;
        this.initialize();
        this.setObject(o);
    }

    public void setObject(AceObject object) {
        if (!object.classe().equalsIgnoreCase("map")) {
            System.err.println("AceObject is not a map");
            throw new ClassCastException("No Map Class");
        }
        if (this.debug) {
            System.out.println(object.classe() + " " + object.name());
        }
        this.map = object;
        this.setMarker();
        this.setLocus();
        this.setInterval();
        this.setFrame();
        this.f.setTitle("Map View: " + this.map.classe() + " " + this.map.name());
    }

    private void initialize() {
        this.f = new JFrame(this.title);
        this.menubar = new MapMenuBar(this);
        this.menubar.showFullMenu(false);
        this.f.setJMenuBar(this.menubar);
        ((Component)this.f).setSize(800, 600);
        this.control = new MapControl(this.range);
    }

    public void setTitle(String t) {
        this.title = t;
        this.f.setTitle(t);
    }

    public void setFrame() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(new BorderLayout());
        this.markerPanel.add((Component)this.getLabel("Marker"), "North");
        this.markerPanel.add((Component)this.getLabel("Marker"), "South");
        this.marker.setPreferredSize(new Dimension(50, 500));
        this.marker.setBorder(BorderFactory.createEtchedBorder());
        this.markerPanel.add((Component)this.marker, "Center");
        this.locator = new MapCartoon(this.range);
        this.locatorPanel = new JPanel();
        this.locatorPanel.setLayout(new BorderLayout());
        this.locatorPanel.add((Component)this.getLabel("Locator"), "North");
        this.locatorPanel.add((Component)this.getLabel("Locator"), "South");
        this.locator.setBorder(BorderFactory.createEtchedBorder());
        this.locator.setMapControl(this.control);
        this.locatorPanel.add((Component)this.locator, "Center");
        JPanel solid = new JPanel();
        solid.setLayout(new BoxLayout(solid, 1));
        solid.setBorder(BorderFactory.createRaisedBevelBorder());
        this.solid1 = new JPanel();
        this.solid1.setLayout(new GridLayout(1, 2));
        this.solid1.setPreferredSize(new Dimension(90, 300));
        this.solid1.add(this.markerPanel);
        this.solid1.add(this.locatorPanel);
        Component blank1 = Box.createVerticalGlue();
        Component blank2 = Box.createVerticalGlue();
        if (this.rangeControl == null) {
            this.rangeControl = new RangeControlPanel();
        }
        this.rangeControl.setBorder(BorderFactory.createEtchedBorder());
        this.rangeControl.setPreferredSize(new Dimension(90, 120));
        solid.setSize(90, 500);
        solid.add(this.solid1);
        solid.add(blank1);
        solid.add(this.rangeControl);
        solid.add(blank2);
        pane.add(solid);
        this.rangeControl.setMapControl(this.control);
        MapScale1 p4 = new MapScale1();
        p4.setRange(this.range);
        p4.setPreferredSize(new Dimension(50, 500));
        p4.setBorder(BorderFactory.createEtchedBorder());
        this.scalePane1 = new JPanel();
        this.scalePane1.setLayout(new BorderLayout());
        this.scalePane1.add((Component)this.getLabel("Scale"), "North");
        this.scalePane1.add((Component)this.getLabel("Scale"), "South");
        this.scalePane1.add((Component)p4, "Center");
        pane.add(this.scalePane1);
        this.itPanel = new JPanel();
        this.itPanel.setLayout(new BorderLayout());
        this.itPanel.add((Component)this.getLabel("Intervals"), "North");
        this.itPanel.add((Component)this.getLabel("Intervals"), "South");
        this.ic.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane sp = new JScrollPane(this.ic);
        sp.setPreferredSize(new Dimension(400, 500));
        this.itPanel.add((Component)sp, "Center");
        this.lcPanel = new JPanel();
        this.lcPanel.setLayout(new BorderLayout());
        this.lcPanel.add((Component)this.getLabel("Loci"), "North");
        this.lcPanel.add((Component)this.getLabel("Loci"), "South");
        this.lc.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane plc = new JScrollPane(this.lc);
        if (this.lc instanceof LocusContainer) {
            ZoomPopupMenu pop1 = new ZoomPopupMenu((MapZoom)((Object)this.lc), this.f);
            this.lc.setPopup(pop1);
        }
        plc.setPreferredSize(new Dimension(400, 500));
        this.lcPanel.add(plc);
        this.split = new JSplitPane(1, this.itPanel, this.lcPanel);
        this.split.setDividerSize(5);
        JPanel splitP = new JPanel();
        splitP.setLayout(new BorderLayout());
        splitP.add((Component)this.split, "Center");
        this.split.setBorder(BorderFactory.createEtchedBorder());
        pane.add(splitP);
        MapScale1 p41 = new MapScale1();
        p41.setRange(this.range);
        p41.setPreferredSize(new Dimension(50, 500));
        p41.setBorder(BorderFactory.createEtchedBorder());
        this.scalePane2 = new JPanel();
        this.scalePane2.setLayout(new BorderLayout());
        this.scalePane2.add((Component)this.getLabel("Scale"), "North");
        this.scalePane2.add((Component)this.getLabel("Scale"), "South");
        this.scalePane2.add((Component)p41, "Center");
        pane.add(this.scalePane2);
        this.setView(new JScrollPane(pane));
        this.f.getContentPane().removeAll();
        this.f.getContentPane().add((Component)new JScrollPane(pane), "Center");
        this.f.validate();
        ((Component)this.f).setVisible(true);
        this.control.addPropertyChangeListener(p4);
        this.control.addPropertyChangeListener(this.lc.getLocusControl());
        this.control.addPropertyChangeListener(this.ic);
        this.control.addPropertyChangeListener(p41);
        this.control.addPropertyChangeListener(this.locator);
        this.lc.getLocusControl().setMapControl(this.control);
        this.ic.setMapControl(this.control);
        this.menubar.showFullMenu(true);
        this.split.setDividerLocation(0.5);
    }

    private JLabel getLabel(String label) {
        JLabel n1 = new JLabel(label);
        n1.setBorder(BorderFactory.createEtchedBorder());
        n1.setForeground(Color.black);
        n1.setHorizontalAlignment(0);
        n1.setFont(new Font("Dialog", 0, 10));
        return n1;
    }

    public void setMarker() {
        String[] params = new String[]{this.map.name()};
        Object[][] markers = this.map.getTable("Map.marker", "Map.marker", params, "kf");
        this.setMarker(markers);
    }

    public void setMarker(Object[][] loci) {
        this.marker = new LocusPanel(this.range);
        int i = 0;
        while (i < loci.length) {
            String name = null;
            AceObject locus = null;
            try {
                locus = (AceObject)loci[i][0];
                name = locus.name();
                if (this.debug) {
                    System.out.println(name);
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("MapView SetLocus(): " + e);
                }
                name = (String)loci[i][0];
            }
            Float position = (Float)loci[i][1];
            float pos = position.floatValue();
            LocusUI ui = new LocusUI(name, pos);
            ui.setHorizontalAlignment(4);
            if (this.debug) {
                System.out.println(locus.name() + "     " + pos);
            }
            if (locus != null) {
                ui.setAceObject(locus);
            }
            this.marker.addLocus(ui);
            ++i;
        }
    }

    public void showMarker(boolean show) {
        if (this.markerPanel != null && this.solid1 != null) {
            this.markerPanel.setVisible(show);
        }
    }

    public void showLocator(boolean show) {
        if (this.locator != null) {
            this.locatorPanel.setVisible(show);
        }
    }

    public void showLeftScale(boolean show) {
        if (this.scalePane1 != null) {
            this.scalePane1.setVisible(show);
        }
    }

    public void showRightScale(boolean show) {
        if (this.scalePane2 != null) {
            this.scalePane2.setVisible(show);
        }
    }

    public void setLocus() {
        String[] params = new String[]{this.map.name()};
        Object[][] loci = this.map.getTable("Map.point", "Map.point", params, "kff");
        if (this.debug) {
            System.out.println(loci.length);
        }
        this.setLocus(loci);
    }

    public void showLocus(boolean show) {
        if (this.lcPanel != null) {
            this.lcPanel.setVisible(show);
            if (show) {
                this.split.setDividerLocation(0.5);
            }
        }
    }

    public void setLocus(Object[][] loci) {
        this.lc = new LocusDisplay(this.range);
        LocusModel lm = new LocusModel();
        int i = 0;
        while (i < loci.length) {
            String name = null;
            AceObject locus = null;
            try {
                locus = (AceObject)loci[i][0];
                name = locus.name();
                if (this.debug) {
                    System.out.println(name);
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("MapView SetLocus(): " + e);
                }
                name = (String)loci[i][0];
            }
            Float position = (Float)loci[i][1];
            float pos = position.floatValue();
            if (this.debug) {
                System.out.println(pos);
            }
            Float error = (Float)loci[i][2];
            float err = error.floatValue();
            if (this.debug) {
                System.out.println(err);
            }
            Locus p = new Locus(name, pos, err, locus);
            if (this.debug) {
                System.out.println(locus.name() + "     " + pos);
            }
            lm.addPoint(p);
            ++i;
        }
        lm.sort(this.comp);
        this.lc.setModel(lm);
    }

    public void setInterval() {
        String[] params = new String[]{this.map.name()};
        Object[][] intervals = this.map.getTable("Map.interval", "Map.interval", params, "kff");
        if (this.debug) {
            System.out.println(intervals.length);
        }
        this.setInterval(intervals);
    }

    public void showInterval(boolean show) {
        if (this.itPanel != null) {
            this.itPanel.setVisible(show);
            if (show) {
                this.split.setDividerLocation(0.5);
            }
        }
    }

    public void setInterval(Object[][] intervals) {
        this.ic = new IntervalContainer(this.range);
        int i = 0;
        while (i < intervals.length) {
            String name = null;
            AceObject interval = null;
            try {
                interval = (AceObject)intervals[i][0];
                name = interval.name();
            }
            catch (Exception e) {
                name = (String)intervals[i][0];
            }
            Float start = (Float)intervals[i][1];
            float s = start.floatValue();
            Float end = (Float)intervals[i][2];
            float e = end.floatValue();
            IntervalUI ui = new IntervalUI(s, e, name);
            if (interval != null) {
                ui.setAceObject(interval);
            }
            this.ic.addInterval(ui);
            ++i;
        }
    }

    public AceObject getObject() {
        return this.map;
    }

    public JComponent getView() {
        return this.view;
    }

    public JFrame getViewFrame() {
        return this.f;
    }

    public void setView(JComponent comp) {
        this.view = comp;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public void search(String cls, String pattern) {
        if (cls.equalsIgnoreCase("locus")) {
            this.lc.doSearch(pattern);
        } else if (cls.equalsIgnoreCase("rearrangement")) {
            this.ic.doSearch(pattern);
        }
    }

    public static void main(String[] args) {
        MapView view = new MapView();
        JFrame f = view.getViewFrame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ((Component)f).setVisible(true);
    }
}

