/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.AceAccessor;
import jadex.swing.AceModel;
import jadex.swing.ClassDisplayer;
import jadex.swing.ClassDisplayerModel;
import jadex.swing.ClassListDisplayer;
import jadex.swing.ClassListModel;
import jadex.swing.MouseSenser;
import jadex.swing.ProgressPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class ClassViewController
implements MouseListener {
    private JPanel fieldCurrentPanel = null;
    private JPanel lastPanel = null;
    protected transient PropertyChangeSupport propertyChange;
    private String fieldClassName = null;
    private AceModel aceModel;
    private AceAccessor accessor;
    private ClassDisplayer ivjClassDisplayer1 = null;
    private ClassListDisplayer ivjClassListDisplayer1 = null;
    private int total;
    private int[] eachCount = new int[26];
    private Thread t = new Thread();
    private boolean tStop;
    private Vector cancellListeners = new Vector();
    private Vector objectList;
    private final int MAXNUMBER = 1000;
    private int currentPosition = 0;

    public ClassViewController() {
    }

    public ClassViewController(String classe, AceModel model) {
        this.setClassName(classe);
        this.setAceModel(model);
        this.initialize();
    }

    public void addCancelActionListener(ActionListener l) {
        this.cancellListeners.addElement(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public AceModel getAceModel() {
        return this.aceModel;
    }

    private ClassDisplayer getClassDisplayer1() {
        return this.ivjClassDisplayer1;
    }

    private ClassListDisplayer getClassListDisplayer1() {
        return this.ivjClassListDisplayer1;
    }

    public String getClassName() {
        return this.fieldClassName;
    }

    public JPanel getCurrentPanel() {
        return this.fieldCurrentPanel;
    }

    private int getCurrentPosition() {
        return this.currentPosition;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        if (this.accessor != null) {
            this.t = new Thread(new Runnable(){

                public void run() {
                    String name = ClassViewController.this.getClassName();
                    JLabel[] localLabels = new JLabel[26];
                    JLabel localAll = new JLabel();
                    localAll.setText("All...");
                    localAll.setFont(new Font("Monospaced", 1, 12));
                    localAll.setBorder(new EtchedBorder());
                    ProgressPanel progress = new ProgressPanel();
                    progress.setName("Downloading");
                    progress.setMaximum(localLabels.length);
                    progress.addActionListener(new CancellAction());
                    int i = 0;
                    while (i < ClassViewController.this.cancellListeners.size()) {
                        progress.addActionListener((ActionListener)ClassViewController.this.cancellListeners.elementAt(i));
                        ++i;
                    }
                    ClassViewController.this.setCurrentPanel(progress);
                    Thread.yield();
                    ClassViewController.this.total = ClassViewController.this.accessor.count(name, "*");
                    if (ClassViewController.this.total > 0) {
                        localAll.setForeground(Color.blue);
                        localAll.addMouseListener(new MouseSenser(localAll));
                        localAll.addMouseListener(ClassViewController.this);
                        localAll.setToolTipText("Total: " + ClassViewController.this.total + " entries");
                    }
                    int j = 0;
                    int anotherCount = 0;
                    ClassViewController.this.tStop = false;
                    char i2 = 'A';
                    while (i2 <= 'Z') {
                        if (ClassViewController.this.tStop) {
                            return;
                        }
                        ((ClassViewController)ClassViewController.this).eachCount[j] = ClassViewController.this.accessor.count(name, i2 + "*");
                        localLabels[j] = new JLabel(i2 + "");
                        localLabels[j].setFont(new Font("Monospaced", 1, 12));
                        if (ClassViewController.this.eachCount[j] != 0) {
                            localLabels[j].setForeground(Color.blue);
                            localLabels[j].setToolTipText(i2 + "*" + ": " + ClassViewController.this.eachCount[j] + " entries");
                            localLabels[j].addMouseListener(new MouseSenser(localLabels[j]));
                            localLabels[j].addMouseListener(ClassViewController.this);
                        }
                        anotherCount = ClassViewController.this.eachCount[j] + anotherCount;
                        progress.setValue(j);
                        Thread.yield();
                        ++j;
                        i2 = (char)(i2 + '\u0001');
                    }
                    ClassDisplayerModel model = new ClassDisplayerModel(name, ClassViewController.this.total, localLabels, localAll);
                    ClassViewController.this.setClassDisplayer1(new ClassDisplayer(model));
                    ClassViewController.this.setCurrentPanel(ClassViewController.this.getClassDisplayer1());
                }
            });
            this.t.start();
        }
    }

    public void mouseClicked(MouseEvent e) {
        JLabel label = null;
        try {
            label = (JLabel)e.getSource();
        }
        catch (ClassCastException ex) {
            System.out.println(ex);
        }
        ClassListModel listModel = new ClassListModel(this.accessor, label, this.getClassDisplayer1().getModel());
        this.setClassListDisplayer1(new ClassListDisplayer(listModel));
        this.setCurrentPanel(this.getClassListDisplayer1());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(listener);
    }

    public void setAceModel(AceModel newValue) {
        this.aceModel = newValue;
        this.accessor = this.aceModel.getAccessor();
        if (this.getClassName() != null) {
            this.initialize();
        }
    }

    private void setClassDisplayer1(ClassDisplayer newValue) {
        if (this.ivjClassDisplayer1 != newValue) {
            try {
                this.ivjClassDisplayer1 = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    private void setClassListDisplayer1(ClassListDisplayer newValue) {
        if (this.ivjClassListDisplayer1 != newValue) {
            try {
                this.ivjClassListDisplayer1 = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setClassName(String className) {
        this.fieldClassName = className;
        if (this.accessor != null) {
            this.initialize();
        }
    }

    public void setCurrentPanel(JPanel currentPanel) {
        this.lastPanel = this.fieldCurrentPanel;
        this.fieldCurrentPanel = currentPanel;
        this.firePropertyChange("currentPanel", this.lastPanel, currentPanel);
    }

    private void setCurrentPosition(int newValue) {
        this.currentPosition = newValue;
    }

    protected class CancellAction
    implements ActionListener {
        protected CancellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClassViewController.this.tStop = true;
            ClassViewController.this.setCurrentPanel(ClassViewController.this.lastPanel);
        }
    }
}

