/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jadex.swing.ClassListDisplayer;
import jadex.swing.ClassListModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JComboBox;

public class ClassListMediator
implements ActionListener,
ItemListener {
    private ClassListDisplayer displayer = null;
    private ClassListModel model = null;
    private int selectedPage;
    private String letter;
    private int selectedLetterIndex;

    public ClassListMediator() {
    }

    public ClassListMediator(ClassListDisplayer classListDisplayer, ClassListModel classListModel) {
        this.displayer = classListDisplayer;
        this.model = classListModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "previous") {
            JComboBox jComboBox = this.displayer.getPageBox();
            jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() - 1);
            jComboBox.repaint();
        } else if (string == "next") {
            JComboBox jComboBox = this.displayer.getPageBox();
            jComboBox.setSelectedIndex(jComboBox.getSelectedIndex() + 1);
            jComboBox.repaint();
        } else if (string == "All...") {
            JComboBox jComboBox = this.displayer.getLetterBox();
            jComboBox.setSelectedIndex(0);
            jComboBox.repaint();
        }
    }

    protected String getLetter() {
        return this.letter;
    }

    protected int getSelectedPage() {
        return this.selectedPage;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.displayer.getPageBox()) {
                String string = (String)itemEvent.getItem();
                this.selectedPage = Integer.parseInt(string);
                String string2 = this.getLetter();
                int n = (this.selectedPage - 1) * 500;
                this.model.fetchObjects(string2, n, 500);
            } else if (itemEvent.getSource() == this.displayer.getLetterBox()) {
                this.parseSelectedItem();
            }
        }
    }

    private void parseSelectedItem() {
        this.selectedLetterIndex = this.displayer.getLetterBox().getSelectedIndex();
        String string = (String)this.displayer.getLetterBox().getSelectedItem();
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        this.setLetter(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1));
        String string3 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string3);
        this.setPageBox(n2);
    }

    public void setDisplayer(ClassListDisplayer classListDisplayer) {
        this.displayer = classListDisplayer;
    }

    private void setLetter(String string) {
        this.letter = string;
    }

    public void setModel(ClassListModel classListModel) {
        this.model = classListModel;
    }

    private void setPageBox(int n) {
        this.displayer.setPageBox(n);
    }
}

