/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jade.db.Accessor;
import jade.db.AceAccessor;
import jade.db.AceObject;
import jade.db.JSAceAccessor;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class AceModel {
    private Vector fieldCategory = new Vector();
    private AceAccessor fieldAccessor;
    private boolean debug = false;
    private String host = null;
    private int port;

    public AceModel() {
        this.init();
    }

    public AceModel(String host, int port) {
        this.host = host;
        this.port = port;
        this.init(false);
    }

    private void init(boolean isDirect) {
        if (!isDirect) {
            this.init();
        } else {
            JSAceAccessor worm = new JSAceAccessor(this.host, this.port);
            this.setAccessor(worm);
            Vector v = worm.classes();
            this.setCategory(v);
        }
    }

    private Vector parseMessage(String str) {
        Vector<String> v = new Vector<String>();
        System.out.println("ParseMessage in AceModel: " + str);
        try {
            LineNumberReader lnr = new LineNumberReader(new CharArrayReader(str.toCharArray()));
            lnr.readLine();
            String s = null;
            while ((s = lnr.readLine()) != null) {
                if (s.length() == 0) continue;
                System.out.println("ParseMessage in AceModel: " + s);
                if (s.indexOf("Active Object") <= -1) {
                    int pos = s.lastIndexOf(" ");
                    String name = s.substring(0, pos).trim();
                    System.out.println(name);
                    v.addElement(name);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return v;
    }

    public AceModel(Accessor accessor) {
        try {
            this.setAccessor((AceAccessor)accessor);
        }
        catch (ClassCastException e) {
            System.err.println(e);
        }
    }

    public AceAccessor getAccessor() {
        return this.fieldAccessor;
    }

    public Vector getCategory() {
        return this.fieldCategory;
    }

    private void init() {
        JSAceAccessor worm = null;
        worm = this.host == null ? new JSAceAccessor("alpha.crbm.cnrs-mop.fr", 20100) : new JSAceAccessor(this.host, this.port);
        this.setAccessor(worm);
        String[] para = new String[]{"Visible"};
        Object[][] result = worm.getTable("Classes", para, "k");
        Vector<String> v = new Vector<String>();
        AceObject ab = null;
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                ab = (AceObject)result[i][j];
                v.addElement(ab.name());
                if (this.debug) {
                    System.out.println(result[i][j]);
                }
                ++j;
            }
            ++i;
        }
        this.setCategory(v);
    }

    public static void main(String[] args) {
        new AceModel(args[0], Integer.parseInt(args[1]));
    }

    public void setAccessor(AceAccessor accessor) {
        this.fieldAccessor = accessor;
    }

    public void setCategory(Vector category) {
        this.fieldCategory = category;
    }
}

