/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing;

import jadex.swing.AceModel;
import jadex.swing.ClassViewController;
import jadex.swing.ProgressPanel;
import jadex.swing.SearchPanel;
import jadex.swing.ViewSettingPanel;
import jadex.swing.WelcomePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AceDBFrame
extends JFrame
implements MouseListener,
WindowListener,
PropertyChangeListener {
    private JPanel ivjJFrameContentPane = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JTree ivjJTree2 = null;
    private Vector fieldNames = new Vector();
    private JScrollPane ivjJScrollPane1 = null;
    private AceModel ivjAceModel = null;
    private JTabbedPane ivjJTabbedPane1 = null;
    private JPanel ivjPage = null;
    private ClassViewController controller;
    private WelcomePane first = new WelcomePane();
    private TreePath lastPath = null;
    private TreePath currentPath = null;
    private String title = null;
    private final String DATABASE_NAME = "AceDB";
    private String host = null;
    private int port;

    public AceDBFrame() {
        this.initialize();
    }

    public AceDBFrame(String host, int port) {
        this.host = host;
        this.port = port;
        this.initialize();
    }

    public void aceDBFrame_WindowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void addTab(JPanel panel) {
        this.getJTabbedPane1().removeAll();
        this.getJTabbedPane1().addTab(panel.getName(), panel);
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.aceDBFrame_WindowClosed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(MouseEvent arg1) {
        try {
            this.jTree2_MouseClickEvents1(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public AceModel getAceModel() {
        if (this.ivjAceModel == null) {
            try {
                this.ivjAceModel = new AceModel();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAceModel;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getJSplitPane1(), "West");
                this.getJFrameContentPane().add((Component)this.getJTabbedPane1(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private void setMenu() {
        JMenuBar bar = new JMenuBar();
        JMenu menu1 = new JMenu("File");
        JMenu menu2 = new JMenu("Search");
        JMenu menu3 = new JMenu("Tools");
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenuItem classSearch = new JMenuItem("Object Search");
        classSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPanel sp = new SearchPanel();
                sp.setDbFrame(AceDBFrame.this);
            }
        });
        JMenuItem viewSetting = new JMenuItem("ClassView Setting");
        viewSetting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewSettingPanel vsp = new ViewSettingPanel();
                vsp.setDbFrame(AceDBFrame.this);
            }
        });
        menu1.add(quit);
        menu2.add(classSearch);
        menu3.add(viewSetting);
        bar.add(menu1);
        bar.add(menu2);
        bar.add(menu3);
        this.setJMenuBar(bar);
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getJTree2());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.ivjJSplitPane1.setAutoscrolls(false);
                this.ivjJSplitPane1.setLastDividerLocation(200);
                this.ivjJSplitPane1.setDividerLocation(200);
                this.ivjJSplitPane1.setOneTouchExpandable(false);
                this.ivjJSplitPane1.setContinuousLayout(false);
                this.getJSplitPane1().add((Component)this.getJScrollPane1(), "left");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JTabbedPane getJTabbedPane1() {
        if (this.ivjJTabbedPane1 == null) {
            try {
                this.ivjJTabbedPane1 = new JTabbedPane();
                this.ivjJTabbedPane1.setName("JTabbedPane1");
                this.ivjJTabbedPane1.setDoubleBuffered(true);
                this.ivjJTabbedPane1.insertTab("Welcome", null, this.getPage(), null, 0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTabbedPane1;
    }

    private JTree getJTree2() {
        if (this.ivjJTree2 == null) {
            try {
                this.ivjJTree2 = new JTree();
                this.ivjJTree2.setName("JTree2");
                this.ivjJTree2.setAutoscrolls(true);
                this.ivjJTree2.setBounds(0, 27, 199, 311);
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("AceDB");
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                Vector names = this.getNames();
                int i = 0;
                while (i < names.size()) {
                    node = new DefaultMutableTreeNode(names.elementAt(i));
                    root.add(node);
                    ++i;
                }
                this.ivjJTree2 = new JTree(root);
                this.ivjJTree2.getSelectionModel().setSelectionMode(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTree2;
    }

    public Vector getNames() {
        return this.fieldNames;
    }

    private JPanel getPage() {
        if (this.ivjPage == null) {
            try {
                this.ivjPage = new JPanel();
                this.ivjPage.setName("Page");
                this.ivjPage.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPage;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getJTree2().addMouseListener(this);
    }

    private void initialize() {
        this.ivjAceModel = this.host != null && this.port != 0 ? new AceModel(this.host, this.port) : new AceModel();
        this.setNames(this.ivjAceModel.getCategory());
        this.setName("AceDBFrame");
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(700, 400);
        this.setTitle("AceDBViewer");
        this.setContentPane(this.getJFrameContentPane());
        this.initConnections();
        this.setMenu();
        this.first.setMessage("Click an entry on the left pane to show information!");
        this.addTab(this.first);
        this.controller = new ClassViewController();
        this.controller.setAceModel(this.getAceModel());
        this.controller.addPropertyChangeListener(this);
        this.controller.addCancelActionListener(new CancellAction());
    }

    public void jTree2_MouseClickEvents1(MouseEvent e) {
        TreePath current = this.getJTree2().getPathForLocation(e.getX(), e.getY());
        this.title = current.getLastPathComponent().toString();
        if (this.title == "AceDB") {
            this.getJTree2().setSelectionPath(this.currentPath);
            return;
        }
        this.lastPath = this.currentPath;
        this.currentPath = current;
        WelcomePane msg = new WelcomePane();
        msg.setMessage("Working, Please wait...");
        this.addTab(msg);
        this.getJTree2().setEnabled(false);
        this.getJTree2().removeMouseListener(this);
        this.controller.setClassName(this.title);
    }

    public static void main(String[] args) {
        AceDBFrame aAceDBFrame = null;
        if (args.length < 2) {
            aAceDBFrame = new AceDBFrame();
        } else {
            String host = args[0];
            String portS = args[1];
            int port = Integer.parseInt(portS);
            aAceDBFrame = new AceDBFrame(host, port);
        }
        ((Component)aAceDBFrame).setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getJTree2()) {
            this.connEtoC2(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void propertyChange(PropertyChangeEvent arg1) {
        JPanel newValue = (JPanel)arg1.getNewValue();
        if (newValue == null) {
            this.getJTree2().setEnabled(true);
            this.getJTree2().addMouseListener(this);
            this.title = null;
            this.addTab(this.first);
            return;
        }
        if (newValue instanceof ProgressPanel) {
            this.getJTree2().setEnabled(false);
            this.getJTree2().removeMouseListener(this);
            this.addTab(newValue);
            return;
        }
        this.getJTree2().setEnabled(true);
        this.getJTree2().removeMouseListener(this);
        this.getJTree2().addMouseListener(this);
        this.addTab(newValue);
    }

    public void setNames(Vector names) {
        this.fieldNames = names;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC1(e);
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private class CancellAction
    implements ActionListener {
        private CancellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Cancel") {
                AceDBFrame.this.currentPath = AceDBFrame.this.lastPath;
                AceDBFrame.this.getJTree2().setSelectionPath(AceDBFrame.this.lastPath);
                AceDBFrame.this.getJTree2().scrollPathToVisible(AceDBFrame.this.lastPath);
            }
        }
    }
}

