/*
 * Decompiled with CFR 0.152.
 */
package jadeSocket;

import java.security.MessageDigest;

public class MD5Test {
    private MessageDigest md = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java MD5 input1 *");
            System.exit(0);
        }
        MD5Test test = new MD5Test();
        String result = test.getMD5(args);
        System.out.println("After digested: " + result + " ---- length: " + result.length());
    }

    public MD5Test() {
        try {
            this.md = MessageDigest.getInstance("MD5");
            this.md.reset();
        }
        catch (Exception e) {
            System.out.println("Constructor in MDTest: " + e);
        }
    }

    public String getMD5(String[] input) {
        String rtn = null;
        int i = 0;
        while (i < input.length) {
            this.md.update(input[i].getBytes());
            ++i;
        }
        try {
            byte[] result = this.md.digest();
            rtn = this.computeDigest(result);
        }
        catch (Exception e) {
            System.out.println("MDTest.getMD5: " + e);
        }
        return rtn;
    }

    protected String computeDigest(byte[] input) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            if ((0xFF & input[i]) < 16) {
                result.append("0" + Integer.toHexString(0xFF & input[i]));
            } else {
                result.append(Integer.toHexString(0xFF & input[i]));
            }
            ++i;
        }
        return result.toString();
    }
}

