/*
 * Decompiled with CFR 0.152.
 */
package jadeSocket;

import jadeSocket.JSAceClient;
import java.io.IOException;

public class JSControl {
    private JSAceClient client = null;
    private String message = null;
    private boolean encore = false;
    private StringBuffer msgBuffer = null;
    private String user = null;
    private String pwd = null;
    private String host = null;
    private int port;
    private boolean debug = false;

    public JSControl(String host, int port) {
        this.host = host;
        this.port = port;
        this.client = new JSAceClient(host, port);
    }

    public void initializeRequest(String user, String pwd) {
        this.user = user;
        this.pwd = pwd;
        try {
            this.client.talk(JSAceClient.HELLO);
            this.client.verify(user, pwd);
        }
        catch (IOException e) {
            System.out.println("Cannot establish connection: " + e);
            System.exit(0);
        }
    }

    protected void reInitializeRequest() {
        this.client = null;
        this.client = new JSAceClient(this.host, this.port);
        this.initializeRequest(this.user, this.pwd);
    }

    private void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public synchronized void request(String query) {
        if (!this.encore) {
            this.msgBuffer = new StringBuffer();
        }
        try {
            this.client.talk(query);
        }
        catch (Exception e) {
            this.reInitializeRequest();
            this.request(query);
        }
        if (this.client.getMsgType().equalsIgnoreCase(JSAceClient.ACESERV_MSGENCORE)) {
            this.encore = true;
            this.msgBuffer.append(this.client.getMessage());
            this.request(JSAceClient.ENCORE);
        }
        this.encore = false;
        this.msgBuffer.append(this.client.getMessage());
        this.setMessage(this.msgBuffer.toString());
        if (this.debug) {
            System.out.println("Message from server in JSControl: " + this.msgBuffer.toString());
        }
    }
}

