/*
 * Decompiled with CFR 0.152.
 */
package jadeSocket;

import jadeSocket.JSControl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class AceClientS {
    private JSControl control = null;
    private String host = null;
    private String user = "guest";
    private String pwd = "guest";
    private int port;
    private boolean debug = false;

    public AceClientS(String host, int port) {
        this.host = host;
        this.port = port;
        this.control = new JSControl(host, port);
        this.control.initializeRequest(this.user, this.pwd);
        this.startCommunication();
    }

    public AceClientS(String host, int port, String user, String pwd) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pwd = pwd;
        this.control = new JSControl(host, port);
        this.control.initializeRequest(user, pwd);
        this.startCommunication();
    }

    private void startCommunication() {
        try {
            while (true) {
                System.out.print("AceDB_Socket> ");
                LineNumberReader query = new LineNumberReader(new InputStreamReader(System.in));
                String queryS = query.readLine();
                if (queryS.length() == 4) {
                    queryS = queryS + " ";
                }
                if (this.debug) {
                    System.out.println(queryS);
                }
                this.control.request(queryS);
                System.out.println(this.control.getMessage());
                if (!queryS.trim().equalsIgnoreCase("quit")) continue;
                System.exit(0);
            }
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(2);
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 4) {
            System.out.println("Usage: java AceClientS host port (user pwd)");
            System.exit(0);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String user = null;
        String pwd = null;
        if (args.length == 4) {
            user = args[2];
            pwd = args[3];
        } else {
            user = "guest";
            pwd = "guest";
        }
        new AceClientS(host, port, user, pwd);
    }
}

