/*
 * Decompiled with CFR 0.152.
 */
package jade.graphics;

import jade.graphics.Box;
import jade.graphics.Graph;
import jade.graphics.Select;
import jade.maps.SetDisplay;
import jade.util.HelpOut;
import jade.util.Jade;
import jade.util.Key;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class BoxObj
extends Box {
    Key him;
    private boolean debug = true;

    public BoxObj(Key key, int n, int n2) {
        this.him = key;
        this.h = 4;
        this.w = 4;
        if (this.him == null) {
            return;
        }
        FontMetrics fontMetrics = Jade.fmPlain;
        switch (this.him.status()) {
            default: {
                this.col = Color.black;
                ((Component)this).setFont(Jade.plainFont);
                fontMetrics = Jade.fmPlain;
                this.h = Jade.fmPlainHeight + 4;
                break;
            }
            case 1: {
                this.col = Color.black;
                ((Component)this).setFont(Jade.italicFont);
                fontMetrics = Jade.fmItalic;
                this.h = Jade.fmItalicHeight + 4;
                break;
            }
            case 2: {
                this.col = Color.blue;
                ((Component)this).setFont(Jade.plainFont);
                fontMetrics = Jade.fmPlain;
                this.h = Jade.fmPlainHeight + 4;
                break;
            }
            case 3: {
                this.col = Color.red;
                ((Component)this).setFont(Jade.boldFont);
                fontMetrics = Jade.fmBold;
                this.h = Jade.fmBoldHeight + 4;
            }
        }
        this.bCol = Color.white;
        this.setForeground(this.col);
        this.setBackground(this.bCol);
        if (fontMetrics == null) {
            this.w = 100;
            System.err.println("null font metric in box obj");
        } else {
            this.w = fontMetrics.stringWidth(key.name) + 4;
        }
        this.x = n;
        this.y = n2 - this.h / 2 - 2;
        this.setBounds(this.x, this.y, this.w, this.h);
    }

    public boolean help(Graph graph) {
        String string;
        switch (this.him.status()) {
            default: {
                string = "You cannot pick me, i am just text";
                break;
            }
            case 1: {
                string = "I do not exist on the server";
                break;
            }
            case 2: {
                string = "Picking me will send request to the server";
                break;
            }
            case 3: {
                string = "I am here, pick me and I'll pop";
            }
        }
        new HelpOut(string, graph);
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.him != null && this.debug) {
            System.err.println("box.paint: " + this.him);
        }
        if (graphics != null && this.him != null && this.him.name() != null) {
            graphics.drawString(this.him.name(), 2, this.h - 4);
        }
    }

    public boolean pick(int n, int n2) {
        if (this.debug) {
            System.err.println("box.pick() called on " + this.him + "status =" + this.him.status());
        }
        this.setActiveKey();
        if (this.activate()) {
            if (this.biActive()) {
                return true;
            }
            this.highLight();
            if (this.debug) {
                System.err.println("box.pick() selecting " + this.him + "status =" + this.him.status());
            }
            new Select(this.him.accessor(), this.him).start();
        }
        return true;
    }

    private void setActiveKey() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof SetDisplay) {
                ((SetDisplay)container).setActiveKey(this.him);
                break;
            }
            container = container.getParent();
        }
    }
}

