/*
 * Decompiled with CFR 0.152.
 */
package jade.graphics;

import jade.graphics.Colorable;
import jade.graphics.Graph;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Panel;

public class Box
extends Panel
implements Colorable {
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    static Box activeBox = null;
    static Box biActiveBox = null;
    public Color col = Color.black;
    public Color bCol = Color.white;
    private static boolean debug = false;

    public Box() {
    }

    public Box(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.setBounds(this.x, this.y, this.w, this.h);
    }

    protected boolean activate() {
        if (this == biActiveBox) {
            return true;
        }
        if (biActiveBox != this) {
            if (biActiveBox != null) {
                biActiveBox.color(this.col, this.bCol);
            }
            biActiveBox = null;
        }
        if (this == activeBox) {
            return true;
        }
        if (debug) {
            System.out.println("box.activate " + this);
        }
        if (activeBox != null) {
            activeBox.color(this.col, this.bCol);
        }
        activeBox = null;
        if (this.col != Color.black) {
            this.color(this.col, Color.yellow);
            activeBox = this;
        }
        return false;
    }

    protected boolean biActive() {
        if (this == biActiveBox) {
            return true;
        }
        if (debug) {
            System.out.println("box.activate " + this);
        }
        biActiveBox = this;
        this.highLight();
        return false;
    }

    public void color(Color color, Color color2) {
        this.setForeground(color);
        this.setBackground(color2);
        this.repaint();
    }

    public Dimension dimension() {
        return new Dimension(this.w, this.h);
    }

    public boolean help(Graph graph) {
        return false;
    }

    private Graph helpOn() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Graph) {
                Graph graph = (Graph)container;
                if (graph.helpMode) {
                    return graph;
                }
                return null;
            }
            container = container.getParent();
        }
        return null;
    }

    protected void highLight() {
        if (debug) {
            System.out.println("box.highLight " + this);
        }
        if (this == activeBox) {
            activeBox = null;
        }
        this.color(this.col, Color.orange);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (debug) {
            System.out.println("Box Mouse down: x=" + n + " y= " + n2 + " " + "\n ev=" + event);
        }
        if (this.helpOn() != null) {
            return false;
        }
        if (event.modifiers == 0) {
            return this.pick(n, n2);
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        Graph graph;
        if (debug) {
            System.out.println("Box Mouse up: x=" + n + " y= " + n2 + " " + "\n ev=" + event);
        }
        if (event.modifiers == 0 && (graph = this.helpOn()) != null) {
            return this.help(graph);
        }
        return false;
    }

    public boolean pick(int n, int n2) {
        if (debug) {
            System.out.println("box.pick() called ");
        }
        return true;
    }

    public void setColor(Color color, Color color2) {
        if (color != null) {
            this.col = color;
            this.setForeground(color);
        }
        if (color2 != null) {
            this.bCol = color2;
            this.setBackground(color2);
        }
        this.repaint();
    }
}

