/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.AceAccessor;
import jade.db.AceCache;
import jade.db.AceObject;
import jade.db.AceString;
import jade.db.AceTable;
import jade.db.PushBackStream;
import jadeSocket.JSControl;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class JSAceAccessor
extends AceAccessor {
    private JSControl control = null;
    private boolean debug = false;
    private boolean debug1 = true;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java JSAceAccessot host port");
            System.exit(0);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        JSAceAccessor movie = new JSAceAccessor(host, port);
        System.out.println("********* TableQuery *********** start");
        String[] params = new String[]{"I"};
        AceTable table = movie.tableQuery("map.point", params);
        System.out.println("TableQuery classes: " + table.dump());
        System.out.println("Col: " + table.colCount());
        System.out.println("Row: " + table.rowCount());
        System.out.println("********* TableQuery *********** end");
    }

    public JSAceAccessor(String host, int port) {
        this.control = new JSControl(host, port);
        this.control.initializeRequest("guest", "guest");
        this.cache = new AceCache(AceAccessor.CACHE_MIN, AceAccessor.CACHE_MAX);
    }

    protected synchronized int countRequest(String query) {
        this.write(query);
        String result = this.read();
        return this.foundCount(result);
    }

    protected int foundCount(String result) {
        int number = 0;
        if (this.debug) {
            System.out.println("JSAceAccessor: " + result);
        }
        int pos = result.indexOf("Active Objects");
        int last = result.lastIndexOf("//");
        try {
            number = Integer.parseInt(result.substring(last + 2, pos).trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (this.debug) {
            System.out.println("JSAceAccessor: " + number);
        }
        return number;
    }

    protected synchronized AceObject low_fetch(String classe, String name, boolean fill) {
        int count = this.count(classe, name);
        if (count < 0) {
            return null;
        }
        if (count > 1) {
            return null;
        }
        AceObject ace = new AceObject(classe, name, this);
        if (fill) {
            ace.fill();
        }
        return ace;
    }

    protected synchronized AceObject low_fill(AceObject a) throws IOException {
        AceObject result = null;
        if (this.count(a.classe, a.name) == 1) {
            this.write("show -j");
            String inputLine = this.read();
            PushBackStream in = new PushBackStream(new BufferedReader(new CharArrayReader(inputLine.toCharArray())));
            inputLine = in.readLine();
            if (this.debug) {
                System.out.println("JSAceAccessor low_fill: " + inputLine);
            }
            String[] elements = new AceString(inputLine).split('\t');
            result = new AceObject(elements, in, 1, this);
            if (this.debug) {
                System.out.println("JSAceAccessor low_fill: " + result);
            }
        }
        return result;
    }

    protected synchronized AceObject[] list(int start, int length) {
        String[] lines;
        Vector<AceObject> objects = new Vector<AceObject>();
        String command = "list -j -b " + start + " -c " + length;
        this.write(command);
        String nextline = this.read();
        if (this.debug) {
            System.out.println("JSAceAccessor list: " + nextline);
        }
        if ((lines = this.parseString(nextline)) != null && lines.length > 0) {
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                AceString a = new AceString(line);
                AceObject ao = this.cache.fetch(a.aceClass(), a.aceID(), true);
                if (ao == null) {
                    ao = new AceObject(a.aceClass(), a.aceID(), this);
                }
                objects.addElement(ao);
                ++i;
            }
            int size = objects.size();
            AceObject[] result = new AceObject[size];
            int i2 = 0;
            while (i2 < size) {
                result[i2] = (AceObject)objects.elementAt(i2);
                ++i2;
            }
            return result;
        }
        return null;
    }

    private String[] parseString(String input) {
        LineNumberReader lnr = new LineNumberReader(new CharArrayReader(input.toCharArray()));
        String line = null;
        Vector<String> v = new Vector<String>();
        try {
            while ((line = lnr.readLine()) != null) {
                if (line.indexOf("?") == -1) continue;
                v.addElement(line);
            }
        }
        catch (IOException e) {
            return null;
        }
        int size = v.size();
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = (String)v.elementAt(i);
            ++i;
        }
        return result;
    }

    public synchronized AceObject[] follow(String classe, String name, String tag, int length) {
        int objects = this.count(classe, name);
        if (objects != 1) {
            return null;
        }
        this.write("follow " + tag);
        return this.list(0, length);
    }

    protected synchronized AceObject table_fill(AceTable a) throws IOException {
        String tbString = null;
        if (a.runtime) {
            if (a.theQuery == null) {
                return null;
            }
            tbString = this.jsTable(a.theQuery);
            if (tbString == null) {
                return null;
            }
        } else {
            tbString = this.jsTable(a.name, a.params);
            if (tbString == null) {
                return null;
            }
        }
        if (this.debug) {
            System.out.println("JSAceAccessor able_fill: " + tbString);
        }
        PushBackStream in = new PushBackStream(new BufferedReader(new CharArrayReader(tbString.toCharArray())));
        a.initializeFromStream(in, this);
        return a.right;
    }

    protected synchronized String jsTable(String[] querys) {
        StringBuffer p = new StringBuffer("table -j =");
        int size = querys.length;
        int i = 0;
        while (i < size - 1) {
            p.append(querys[i] + "\n");
            ++i;
        }
        p.append(querys[size - 1]);
        this.write(p.toString());
        return this.read();
    }

    protected synchronized String jsTable(String name, String[] parameters) {
        StringBuffer p = new StringBuffer("table -j -n");
        p.append(" " + name);
        int i = 0;
        while (i < parameters.length) {
            p.append(" " + parameters[i]);
            ++i;
        }
        this.write(p.toString());
        return this.read();
    }

    public Vector classes() {
        this.write("class");
        String input = this.read();
        if (this.debug) {
            System.out.println("JSAceAccessor classes: " + input);
        }
        Vector<String> v = new Vector<String>();
        try {
            LineNumberReader lnr = new LineNumberReader(new CharArrayReader(input.toCharArray()));
            lnr.readLine();
            String s = null;
            while ((s = lnr.readLine()) != null) {
                if (s.length() == 0) continue;
                if (this.debug) {
                    System.out.println("ParseMessage in AceModel: " + s);
                }
                if (s.indexOf("Active Object") <= -1) {
                    int pos = s.lastIndexOf(" ");
                    String name = s.substring(0, pos).trim();
                    if (this.debug) {
                        System.out.println(name);
                    }
                    v.addElement(name);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return v;
    }

    public void write(String query) {
        this.control.request(query);
    }

    public String read() {
        return this.control.getMessage();
    }
}

