/*
 * Decompiled with CFR 0.152.
 */
package jade.db;

import jade.db.AceNode;
import jade.db.AceObject;
import java.util.Hashtable;

class AceCache {
    protected int maxObjects = 1500;
    protected int minObjects = 1000;
    protected int highWaterMark = Integer.MIN_VALUE;
    protected int lowWaterMark = Integer.MAX_VALUE;
    protected int objectsAdded = 0;
    protected int cacheHits = 0;
    protected int cacheMisses = 0;
    private AceNode listTop = new AceNode(null);
    private AceNode listBottom = new AceNode(null, this.listTop);
    private AceNode reservedNode = new AceNode(null);
    private Hashtable dictionary;
    private static boolean debug = false;

    AceCache() {
        this.dictionary = new Hashtable(this.minObjects);
    }

    AceCache(int n, int n2) {
        this.minObjects = n;
        this.maxObjects = n2;
        this.dictionary = new Hashtable(this.minObjects);
    }

    protected synchronized void add(AceObject aceObject) {
        AceNode aceNode = new AceNode(aceObject, this.listTop);
        ++this.objectsAdded;
        this.dictionary.put(this.hash(aceObject.classe(), aceObject.registration_id()), aceNode);
        this.notifyAll();
        this.gc();
    }

    protected void clearStats() {
        this.lowWaterMark = Integer.MAX_VALUE;
        this.highWaterMark = Integer.MIN_VALUE;
        this.objectsAdded = 0;
        this.cacheHits = 0;
        this.cacheMisses = 0;
    }

    protected void dumpStats() {
        System.err.println("============= cache statistics ============");
        System.err.println("Low water mark (objects):  " + this.lowWaterMark);
        System.err.println("High water mark (objects): " + this.highWaterMark);
        System.err.println("Objects added:             " + this.objectsAdded);
        System.err.println("Cache hits:                " + this.cacheHits);
        System.err.println("Cache misses:              " + this.cacheMisses);
        if (this.cacheHits + this.cacheMisses > 0) {
            System.err.println("Hit rate (%):              " + 100.0 * (double)this.cacheHits / (double)(this.cacheHits + this.cacheMisses));
        }
    }

    protected synchronized AceObject fetch(String string, String string2, boolean bl) {
        AceNode aceNode;
        if (debug) {
            System.err.println("AceCache.fetch() called for " + this.hash(string, string2));
        }
        if ((aceNode = this.lookup(string, string2)) == null) {
            ++this.cacheMisses;
            if (bl) {
                this.reserve(string, string2);
            }
            return null;
        }
        ++this.cacheHits;
        this.touch(aceNode);
        if (debug) {
            System.err.println("AceCache.fetch() cache hit on " + aceNode.object);
        }
        return aceNode.object;
    }

    protected void gc() {
        int n = this.dictionary.size();
        if (n > this.highWaterMark) {
            this.highWaterMark = n;
        }
        if (n > this.maxObjects) {
            int n2 = n - this.minObjects - 2;
            while (n2 > 0 && this.listBottom.left != this.listTop) {
                AceNode aceNode = this.listBottom.left;
                if (debug) {
                    System.err.println("AceCache.gc(): uncaching object " + aceNode.object);
                }
                if (aceNode.object == null) {
                    System.err.println("AceCache.gc(): tried to delete a NULL ace object from the cache");
                } else {
                    aceNode.object.unfill();
                }
                this.dictionary.remove(this.hash(aceNode.object.classe(), aceNode.object.registration_id()));
                this.listBottom.left.delete();
                --n2;
            }
        }
        if ((n = this.dictionary.size()) < this.lowWaterMark) {
            this.lowWaterMark = n;
        }
    }

    protected String hash(String string, String string2) {
        return "?" + string + "?" + string2 + "?";
    }

    protected AceNode lookup(AceObject aceObject) {
        return this.lookup(aceObject.classe(), aceObject.registration_id());
    }

    protected synchronized AceNode lookup(String string, String string2) {
        AceNode aceNode = (AceNode)this.dictionary.get(this.hash(string, string2));
        if (debug) {
            System.err.println("AceCache.lookup(): got " + aceNode);
        }
        while (aceNode == this.reservedNode) {
            try {
                if (debug) {
                    System.err.println("Waiting on a reserved node...");
                }
                this.wait();
                aceNode = (AceNode)this.dictionary.get(this.hash(string, string2));
            }
            catch (InterruptedException interruptedException) {}
        }
        return aceNode;
    }

    protected synchronized void reserve(String string, String string2) {
        AceNode aceNode = (AceNode)this.dictionary.get(this.hash(string, string2));
        if (aceNode != null) {
            return;
        }
        if (debug) {
            System.err.println("AceCache: reserving ?" + string + "?" + string2 + "?");
        }
        this.dictionary.put(this.hash(string, string2), this.reservedNode);
    }

    protected void touch(AceNode aceNode) {
        if (debug) {
            System.err.println("Touching " + aceNode);
        }
        aceNode.insert(this.listTop);
    }

    synchronized void touch(AceObject aceObject) {
        AceNode aceNode = (AceNode)this.dictionary.get(this.hash(aceObject.classe, aceObject.registration_id()));
        if (aceNode == null || aceNode == this.reservedNode) {
            if (debug) {
                System.err.println("Cache: adding " + aceObject);
            }
            this.add(aceObject);
            return;
        }
        this.touch(aceNode);
    }

    protected synchronized void unreserve(String string, String string2) {
        AceNode aceNode;
        if (debug) {
            System.err.println("AceCache: unreserving ?" + string + "?" + string2 + "?");
        }
        if ((aceNode = (AceNode)this.dictionary.get(this.hash(string, string2))) != this.reservedNode) {
            return;
        }
        this.dictionary.remove(this.hash(string, string2));
        this.notifyAll();
    }
}

