/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.swing.map.MapRange;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class XMLUtilities {
    public static Namespace getNamespace() {
        return Namespace.getNamespace((String)"http://www.wormbase.org");
    }

    public static long[] getPositions(Element sequence, Namespace ns) {
        Element range = sequence.getChild("Range", ns);
        if (range == null) {
            return null;
        }
        return XMLUtilities.parseRange(range);
    }

    public static long[] getPositions(Element sequence) {
        Element range = sequence.getChild("Range");
        if (range == null) {
            return null;
        }
        return XMLUtilities.parseRange(range);
    }

    public static MapRange getMapRange(Element sequence, Namespace ns) {
        long[] pos = XMLUtilities.getPositions(sequence, ns);
        return new MapRange(pos[0], pos[1]);
    }

    public static MapRange getMapRange(Element sequence) {
        long[] pos = XMLUtilities.getPositions(sequence);
        return new MapRange(pos[0], pos[1]);
    }

    private static long[] parseRange(Element range) {
        long[] pos = new long[2];
        Attribute startA = range.getAttribute("start");
        Attribute endA = range.getAttribute("end");
        String startS = startA.getValue();
        String endS = endA.getValue();
        pos[0] = Long.parseLong(startS);
        pos[1] = Long.parseLong(endS);
        return pos;
    }

    public static List getSubSequences(Element sequence) {
        Element sub = sequence.getChild("Subsequence");
        if (sub == null) {
            return null;
        }
        return sub.getChildren("Sequence");
    }

    public static List getSubSequences(Element sequence, Namespace ns) {
        Element sub = sequence.getChild("Subsequence", ns);
        if (sub == null) {
            return null;
        }
        return sub.getChildren("Sequence", ns);
    }

    public static String getName(Element sequence) {
        Attribute name = sequence.getAttribute("name");
        return name.getValue();
    }

    public static int getLayer(Element sequence) {
        int layer = 0;
        Element element = sequence;
        while (!element.isRootElement()) {
            element = element.getParent();
            ++layer;
        }
        return layer / 2;
    }

    public static boolean isOdd(Element sequence) {
        if (sequence.isRootElement()) {
            return false;
        }
        Element parent = sequence.getParent();
        List list = parent.getChildren("Sequence", sequence.getNamespace());
        int index = list.indexOf(sequence);
        return index % 2 != 0;
    }
}

