/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.HorizontalMapScale;
import jadex.swing.sequence.HorizontalMiniMapCartoon;
import jadex.swing.sequence.SequenceActions;
import jadex.swing.sequence.SequenceDisplay;
import jadex.swing.sequence.SequenceDisplayAndTreeAdapter;
import jadex.swing.sequence.SequenceFetcher;
import jadex.swing.sequence.SequenceModel;
import jadex.swing.sequence.SequenceTreeDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class SequenceViewFactory {
    private SequenceDisplay display = null;
    private HorizontalMapScale mapscale = null;
    private SequenceTreeDisplay treeDisplay = null;
    private HorizontalMiniMapCartoon cartoon = null;
    private SequenceDisplayAndTreeAdapter adapter = null;
    private final String saxdriver = "org.brownell.xml.aelfred2.SAXDriver";

    public SequenceViewFactory(JFrame frame) {
        this.initialize(frame);
    }

    public SequenceViewFactory(JApplet applet) {
        this.initialize(applet);
    }

    private void initialize(JFrame frame) {
        frame.setTitle("Sequence View: ");
        frame.addWindowListener(new 1(frame));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JSplitPane sp = this.setUI(screenSize.width, screenSize.height - 30);
        SequenceActions actions = SequenceActions.getInstance();
        actions.setSequenceDisplay(this.display);
        JToolBar toolBar = this.setUpToolBar(actions);
        JMenuBar menubar = this.setUpMenuBar(actions);
        JPopupMenu popup = this.setUpPopup(actions);
        this.display.setPopup(popup);
        frame.getContentPane().add((Component)toolBar, "North");
        frame.getContentPane().add((Component)new JScrollPane(sp), "Center");
        frame.setJMenuBar(menubar);
        ((Component)frame).setSize(screenSize.width, screenSize.height - 30);
        ((Component)frame).setVisible(true);
    }

    private void initialize(JApplet applet) {
        JSplitPane sp = this.setUI(applet.getWidth(), applet.getHeight());
        SequenceActions actions = SequenceActions.getInstance(true);
        actions.setSequenceDisplay(this.display);
        JToolBar toolBar = this.setUpToolBar(actions);
        JPopupMenu popup = this.setUpPopup(actions);
        this.display.setPopup(popup);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new BorderLayout());
        panel.add((Component)toolBar, "North");
        panel.add((Component)sp, "Center");
        applet.getContentPane().add((Component)panel, "Center");
    }

    private JSplitPane setUI(int width, int height) {
        this.display = new SequenceDisplay();
        this.display.updateUI();
        this.mapscale = new HorizontalMapScale();
        this.display.addPropertyChangeListener(this.mapscale);
        JPanel panel1 = new JPanel();
        panel1.setBorder(BorderFactory.createEtchedBorder());
        panel1.setLayout(new BorderLayout());
        panel1.add((Component)this.display, "Center");
        panel1.add((Component)this.mapscale, "South");
        this.mapscale.setPreferredSize(new Dimension(width - 24, 25));
        this.display.setPreferredSize(new Dimension(width - 24, 325));
        panel1.setMinimumSize(new Dimension(width - 24, 350));
        this.treeDisplay = new SequenceTreeDisplay();
        this.treeDisplay.setPreferredSize(new Dimension(width - 24, 250));
        JSplitPane sp = new JSplitPane(0);
        sp.setDividerSize(5);
        sp.add(panel1);
        sp.add(this.treeDisplay);
        return sp;
    }

    private JToolBar setUpToolBar(SequenceActions actions) {
        JToolBar toolBar = new JToolBar();
        toolBar.add(actions.getResetAction()).setToolTipText("Reset");
        toolBar.add(actions.getZoomAction()).setToolTipText("Zoom");
        toolBar.add(actions.getZoomInAction()).setToolTipText("Zoom In");
        toolBar.add(actions.getZoomOutAction()).setToolTipText("Zoom Out");
        toolBar.add(actions.getMoveLeftAction()).setToolTipText("Move Left");
        toolBar.add(actions.getMoveRightAction()).setToolTipText("Move Right");
        toolBar.addSeparator();
        toolBar.add(actions.getSearchAction()).setToolTipText("Search");
        this.cartoon = new HorizontalMiniMapCartoon();
        this.display.addPropertyChangeListener(this.cartoon);
        PositionLabel posLabel = new PositionLabel();
        this.display.addPropertyChangeListener(posLabel);
        JPanel cartoonP = new JPanel();
        cartoonP.setLayout(new FlowLayout(2));
        cartoonP.add(posLabel);
        cartoonP.add(this.cartoon);
        toolBar.add(cartoonP);
        return toolBar;
    }

    private JMenuBar setUpMenuBar(SequenceActions actions) {
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(actions.getExitAction());
        JMenu view = new JMenu("View");
        view.add(actions.getZoomAction());
        view.add(actions.getZoomInAction());
        view.add(actions.getZoomOutAction());
        view.addSeparator();
        view.add(actions.getMoveLeftAction());
        view.add(actions.getMoveRightAction());
        view.addSeparator();
        view.add(actions.getResetAction());
        JMenu search = new JMenu("Search");
        search.add(actions.getSearchAction());
        JMenu help = new JMenu("Help");
        help.add(actions.getHelpAction());
        menubar.add(file);
        menubar.add(view);
        menubar.add(search);
        menubar.add(help);
        return menubar;
    }

    private JPopupMenu setUpPopup(SequenceActions actions) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(actions.getZoomAction());
        popup.add(actions.getZoomInAction());
        popup.add(actions.getZoomOutAction());
        popup.addSeparator();
        popup.add(actions.getMoveLeftAction());
        popup.add(actions.getMoveRightAction());
        popup.addSeparator();
        popup.add(actions.getResetAction());
        return popup;
    }

    public void setSequenceFetcher(SequenceFetcher fetcher) {
        SequenceModel model = new SequenceModel(fetcher);
        this.display.setModel(model);
        this.treeDisplay.setRootElement(model.getRoot());
        this.adapter = new SequenceDisplayAndTreeAdapter(this.display, this.treeDisplay);
        this.cartoon.setFullMapRange(this.display.getMapRange());
    }

    public void search(String sequence) {
        if (this.display != null) {
            this.display.search(sequence);
        }
    }

    public void clear() {
        if (this.adapter != null) {
            this.adapter.clear();
        }
        if (this.display != null) {
            this.display.clear();
        }
        if (this.treeDisplay != null) {
            this.treeDisplay.clear();
        }
    }

    public SequenceDisplay getSequenceDisplay() {
        return this.display;
    }

    public SequenceTreeDisplay getTreeDisplay() {
        return this.treeDisplay;
    }

    class PositionLabel
    extends JLabel
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase("mousePosition")) {
                Long pos = (Long)e.getNewValue();
                String posString = NumberFormat.getNumberInstance().format(pos);
                this.setText("Mouse at: " + posString + " bp");
            }
        }

        PositionLabel() {
        }
    }

    private final class 1
    extends WindowAdapter {
        private final /* synthetic */ JFrame val$frame;

        public void windowClosing(WindowEvent e) {
            SequenceViewFactory.this.clear();
            ((Component)this.val$frame).setVisible(false);
            this.val$frame.dispose();
        }

        /* synthetic */ 1(JFrame val$frame) {
            this.val$frame = val$frame;
        }
    }
}

