/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import jadex.swing.sequence.GeneRenderer;
import jadex.swing.sequence.SequenceDisplay;
import jadex.swing.sequence.SequenceLayoutModel;
import jadex.swing.sequence.SequenceModel;
import jadex.swing.sequence.SequenceRenderer;
import jadex.swing.sequence.SequenceSelectionEvent;
import jadex.swing.sequence.SequenceSelectionListener;
import jadex.swing.sequence.SequenceSelectionModel;
import jadex.xml.XMLUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import org.jdom.Element;
import org.jdom.Namespace;

public class SequenceUI
extends ComponentUI
implements Serializable {
    private CellRendererPane rendererPane = null;
    private SequenceDisplay display = null;
    private MouseInputListener mouseHandler = null;
    private SelectionEventHandler selectionHandler = null;
    private PropertyChangeHandler propertyHandler = null;
    private SequenceLayoutModel layoutModel = null;
    private int currentLayer = 0;
    private Namespace ns = null;
    private boolean doSelection = false;
    private Rectangle paintBounds = null;
    private Color connColor = new Color(204, 204, 255);

    public void installUI(JComponent c) {
        this.display = (SequenceDisplay)c;
        this.rendererPane = new CellRendererPane();
        this.display.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
    }

    protected void installDefaults() {
        this.display.setLayout(null);
        this.display.setBorder(BorderFactory.createEtchedBorder());
        if (this.display.getRenderer() == null) {
            this.display.setRenderer(new SequenceRenderer());
        }
        if (this.display.getGeneRenderer() == null) {
            this.display.setGeneRenderer(new GeneRenderer());
        }
        if (this.display.getLayoutModel() == null) {
            this.layoutModel = new SequenceLayoutModel(this.display);
            this.display.setLayoutModel(this.layoutModel);
        } else {
            this.layoutModel = this.display.getLayoutModel();
        }
    }

    protected void installListeners() {
        this.mouseHandler = new MouseEventHandler();
        this.display.addMouseListener(this.mouseHandler);
        this.display.addMouseMotionListener(this.mouseHandler);
        this.propertyHandler = new PropertyChangeHandler();
        this.display.addPropertyChangeListener(this.propertyHandler);
        this.selectionHandler = new SelectionEventHandler();
        SequenceSelectionModel selectionModel = this.display.getSelectionModel();
        if (selectionModel == null) {
            selectionModel = new SequenceSelectionModel();
            this.display.setSelectionModel(selectionModel);
        }
        selectionModel.addSelectionListener(this.selectionHandler);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.display.remove(this.rendererPane);
        this.rendererPane = null;
        this.display = null;
    }

    protected void uninstallDefaults() {
        if (this.display.getRenderer() != null) {
            this.display.setRenderer(null);
        }
        if (this.display.getGeneRenderer() != null) {
            this.display.setGeneRenderer(null);
        }
        if (this.display.getLayoutModel() != null) {
            this.display.setLayoutModel(null);
        }
    }

    protected void uninstallListeners() {
        this.display.removeMouseListener(this.mouseHandler);
        this.display.removeMouseMotionListener(this.mouseHandler);
        SequenceSelectionModel model = this.display.getSelectionModel();
        if (model != null) {
            model.removeSelectionListener(this.selectionHandler);
        }
    }

    public void paint(Graphics g, JComponent c) {
        SequenceModel model = this.display.getModel();
        if (model == null) {
            return;
        }
        SequenceRenderer renderer = this.display.getRenderer();
        if (renderer == null) {
            return;
        }
        SequenceSelectionModel selectionModel = this.display.getSelectionModel();
        List list = selectionModel.getSelection();
        if (this.doSelection) {
            boolean isOdd;
            this.doSelection = false;
            Element seq = selectionModel.getSelected();
            Component comp = renderer.getSequenceRenderer(seq, this.selectionHandler.isSelected(), false);
            if (comp == null) {
                return;
            }
            int layer = XMLUtilities.getLayer(seq);
            Rectangle rect = this.layoutModel.getBounds(seq, layer, isOdd = XMLUtilities.isOdd(seq));
            if (rect == null) {
                return;
            }
            this.rendererPane.paintComponent(g, comp, this.display, rect.x, rect.y, rect.width, rect.height, true);
            return;
        }
        this.layoutModel.relayout();
        this.paintBounds = g.getClipBounds();
        this.paintRootSequence(g, renderer, list);
        g.dispose();
    }

    private void paintRootSequence(Graphics g, SequenceRenderer renderer, List list1) {
        Element root = this.display.getModel().getRoot();
        if (root == null) {
            return;
        }
        this.paintSequence(g, renderer, root, 0, false, list1);
    }

    protected void paintSequence(Graphics g, SequenceRenderer renderer, Element sequence, List list1) {
        int layer = XMLUtilities.getLayer(sequence);
        boolean isOdd = XMLUtilities.isOdd(sequence);
        this.paintSequence(g, renderer, sequence, layer, isOdd, list1);
    }

    protected void paintSequence(Graphics g, SequenceRenderer renderer, Element sequence, int layer, boolean isOdd, List list1) {
        if (sequence == null) {
            return;
        }
        this.paintSingleSequence(g, renderer, sequence, layer, isOdd, list1);
        Element sub = sequence.getChild("Subsequence", this.ns);
        if (sub == null) {
            return;
        }
        List list = sub.getChildren("Sequence", this.ns);
        ++this.currentLayer;
        boolean odd = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element seq = (Element)it.next();
            this.paintSequence(g, renderer, seq, this.currentLayer, odd, list1);
            boolean bl = odd = !odd;
        }
        --this.currentLayer;
    }

    protected void paintSingleSequence(Graphics g, SequenceRenderer renderer, Element sequence, int layer, boolean isOdd, List list1) {
        Rectangle rect = this.layoutModel.getBounds(sequence, layer, isOdd);
        if (rect == null) {
            return;
        }
        if (rect.width < 1) {
            rect.width = 1;
        }
        g.setClip(rect);
        g.clipRect(this.paintBounds.x, this.paintBounds.y, this.paintBounds.width, this.paintBounds.height);
        if (g.getClipBounds().width == 0) {
            return;
        }
        Component comp = renderer.getSequenceRenderer(sequence, list1.contains(sequence), false);
        if (comp == null) {
            return;
        }
        this.rendererPane.paintComponent(g, comp, this.display, rect.x, rect.y, rect.width, rect.height, true);
        if (list1.contains(sequence)) {
            this.paintGene(sequence, rect, g);
        }
    }

    private void paintGene(Element seq, Rectangle rect1, Graphics g) {
        Element gene = seq.getChild("Gene", seq.getNamespace());
        if (gene == null) {
            return;
        }
        MapRange range = XMLUtilities.getMapRange(seq, seq.getNamespace());
        long bp = 0L;
        try {
            bp = range.getExtend();
        }
        catch (UnknownPositionException e) {
            System.err.println("SequenceUI.paint(): " + e);
        }
        GeneRenderer geneRenderer = this.display.getGeneRenderer();
        JComponent comp = geneRenderer.getGeneRenderer(gene, this.display, bp);
        Rectangle rect = this.layoutModel.getGeneBounds(rect1);
        g.setClip(rect);
        g.clipRect(this.paintBounds.x, this.paintBounds.y, this.paintBounds.width, this.paintBounds.height);
        if (g.getClipBounds().width == 0) {
            return;
        }
        this.rendererPane.paintComponent(g, comp, this.display, rect.x, rect.y, rect.width, rect.height, true);
        int midX = (rect1.x + rect1.x + rect1.width) / 2;
        g.setClip(midX, rect.y + rect.height, 1, rect1.y - rect.y);
        g.setColor(this.connColor);
        g.drawLine(midX, rect1.y, midX, rect.y + rect.height);
    }

    protected void paintSelectedSequence(Element seq) {
        boolean isOdd;
        if (seq.getChild("Gene", seq.getNamespace()) != null) {
            this.doSelection = false;
            this.display.repaint();
            return;
        }
        int layer = XMLUtilities.getLayer(seq);
        Rectangle rect = this.layoutModel.getBounds(seq, layer, isOdd = XMLUtilities.isOdd(seq));
        if (rect == null) {
            return;
        }
        this.doSelection = true;
        this.display.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    static /* synthetic */ void access$1(SequenceUI accsParam$0, SequenceDisplay accParam$1) {
        accsParam$0.display = accParam$1;
    }

    static /* synthetic */ void access$3(SequenceUI accsParam$0, SequenceLayoutModel accParam$1) {
        accsParam$0.layoutModel = accParam$1;
    }

    class SelectionEventHandler
    implements SequenceSelectionListener {
        private boolean isSelected;

        public void valueChanged(SequenceSelectionEvent e) {
            if (e.isMultiSelected()) {
                SequenceUI.this.display.repaint();
            } else {
                Element seq = e.getSequence();
                this.isSelected = e.isSelected();
                SequenceUI.this.paintSelectedSequence(seq);
            }
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        SelectionEventHandler() {
        }
    }

    class MouseEventHandler
    implements MouseInputListener {
        private boolean isZoom = false;
        private int inX;
        private int inY;
        private Graphics2D g2;
        private Rectangle zoom = null;

        public void mousePressed(MouseEvent p1) {
            if (p1.isPopupTrigger()) {
                if (SequenceUI.this.display.getPopup() != null) {
                    SequenceUI.this.display.getPopup().show(SequenceUI.this.display, p1.getX(), p1.getY());
                }
            } else if (!this.isZoom) {
                this.inX = p1.getX();
                this.inY = p1.getY();
                this.isZoom = true;
                this.zoom = null;
                this.g2 = (Graphics2D)SequenceUI.this.display.getGraphics();
                this.g2.setColor(Color.red);
                this.g2.fill(new Ellipse2D.Float(this.inX, this.inY, 1.0f, 1.0f));
            }
        }

        public void mouseEntered(MouseEvent p1) {
        }

        public void mouseClicked(MouseEvent p1) {
            Element seq = SequenceUI.this.layoutModel.getClosestElement(p1.getX(), p1.getY());
            if (seq == null) {
                if (this.zoom == null) {
                    return;
                }
                if (this.zoom.contains(p1.getPoint())) {
                    SequenceUI.this.layoutModel.zoom(this.zoom);
                } else {
                    SequenceUI.this.display.repaint(this.zoom.x, this.zoom.y, this.zoom.width + 1, this.zoom.height + 1);
                }
                this.zoom = null;
                this.isZoom = false;
                return;
            }
            if (SequenceUI.this.display.getSelectedSequences().contains(seq)) {
                SequenceUI.this.display.deSelectSequence(seq);
            } else {
                SequenceUI.this.display.setSelectedSequence(seq);
            }
            this.isZoom = false;
        }

        public void mouseReleased(MouseEvent p1) {
            if (p1.isPopupTrigger()) {
                if (SequenceUI.this.display.getPopup() != null) {
                    SequenceUI.this.display.getPopup().show(SequenceUI.this.display, p1.getX(), p1.getY());
                }
                this.isZoom = false;
            } else if (this.isZoom && this.zoom == null) {
                int outX = p1.getX();
                int outY = p1.getY();
                this.zoom = new Rectangle(this.inX, this.inY, outX - this.inX, outY - this.inY);
                this.g2.draw(this.zoom);
            }
        }

        public void mouseExited(MouseEvent p1) {
        }

        public void mouseDragged(MouseEvent p1) {
        }

        public void mouseMoved(MouseEvent p1) {
            SequenceUI.this.layoutModel.setMouseAt(SequenceUI.this.layoutModel.fromXtoBp(p1.getX()));
        }

        MouseEventHandler() {
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equalsIgnoreCase("SequenceModel")) {
                SequenceModel model = (SequenceModel)e.getNewValue();
                Element root = model.getRoot();
                SequenceUI.this.ns = model.getNamespace();
                long[] pos = XMLUtilities.getPositions(root, SequenceUI.this.ns);
                SequenceUI.this.display.getLayoutModel().setTotalBP(pos[1]);
            } else if (name.equalsIgnoreCase("range")) {
                SequenceUI.this.display.setMapRange((MapRange)e.getNewValue());
            }
        }

        PropertyChangeHandler() {
        }
    }
}

