/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import jadex.xml.XMLUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jdom.Element;

public class SequenceTreeNode
implements TreeNode {
    private Element sequence = null;
    private List list = null;
    private Comparator posComp;
    private Comparator nameComp;

    public SequenceTreeNode() {
        this.posComp = new 1();
        this.nameComp = new 2();
    }

    public SequenceTreeNode(Element seq) {
        this.posComp = new 3();
        this.nameComp = new 4();
        this.setSequence(seq);
    }

    public void setSequence(Element seq) {
        this.sequence = seq;
        if (seq != null) {
            this.list = XMLUtilities.getSubSequences(this.sequence, this.sequence.getNamespace());
            if (this.list != null) {
                Collections.sort(this.list, this.nameComp);
            }
        }
    }

    public Element getSequence() {
        return this.sequence;
    }

    public String toString() {
        return this.sequence.getAttributeValue("name");
    }

    public boolean equals(Object o) {
        if (o instanceof SequenceTreeNode) {
            SequenceTreeNode node = (SequenceTreeNode)o;
            return this.sequence.equals((Object)node.getSequence());
        }
        return false;
    }

    public int getIndex(TreeNode p1) {
        if (this.list == null) {
            return -1;
        }
        SequenceTreeNode node = (SequenceTreeNode)p1;
        Element seq2 = node.getSequence();
        return this.list.indexOf(seq2);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int p1) {
        if (this.list == null) {
            return null;
        }
        Element seq = (Element)this.list.get(p1);
        return new SequenceTreeNode(seq);
    }

    public int getChildCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public Enumeration children() {
        return Collections.enumeration(this.list);
    }

    public boolean isLeaf() {
        return this.list == null || this.list.size() == 0;
    }

    public TreeNode getParent() {
        if (this.sequence.isRootElement()) {
            return null;
        }
        Element parent = this.sequence.getParent().getParent();
        return new SequenceTreeNode(parent);
    }

    private final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long pos1 = 0L;
            long pos2 = 0L;
            try {
                pos1 = (range1.getStart() + range1.getEnd()) / 2L;
                pos2 = (range2.getStart() + range2.getEnd()) / 2L;
            }
            catch (UnknownPositionException e) {
                System.err.println("SequenceTreeNode.posComp: " + e);
            }
            int rtn = 0;
            if (pos1 - pos2 < 0L) {
                rtn = -1;
            } else if (pos1 - pos2 > 0L) {
                rtn = 1;
            }
            return rtn;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            Element seq1 = (Element)obj1;
            Element seq2 = (Element)obj2;
            String name1 = seq1.getAttributeValue("name");
            String name2 = seq2.getAttributeValue("name");
            return name1.compareTo(name2);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long pos1 = 0L;
            long pos2 = 0L;
            try {
                pos1 = (range1.getStart() + range1.getEnd()) / 2L;
                pos2 = (range2.getStart() + range2.getEnd()) / 2L;
            }
            catch (UnknownPositionException e) {
                System.err.println("SequenceTreeNode.posComp: " + e);
            }
            int rtn = 0;
            if (pos1 - pos2 < 0L) {
                rtn = -1;
            } else if (pos1 - pos2 > 0L) {
                rtn = 1;
            }
            return rtn;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            Element seq1 = (Element)obj1;
            Element seq2 = (Element)obj2;
            String name1 = seq1.getAttributeValue("name");
            String name2 = seq2.getAttributeValue("name");
            return name1.compareTo(name2);
        }

        /* synthetic */ 4() {
        }
    }
}

