/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.SequenceElementTableView;
import jadex.swing.sequence.SequenceModel;
import jadex.swing.sequence.SequenceTreeNode;
import jadex.swing.sequence.SequenceXMLFetcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;

public class SequenceTreeDisplay
extends JPanel {
    private JTree tree = null;
    private JTabbedPane contentPane = null;
    private JScrollPane sp = null;
    private TreeSelectionListener selectionListener = null;
    private TreeModel treeModel = null;

    public SequenceTreeDisplay() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane(1);
        this.sp = new JScrollPane();
        this.sp.setMinimumSize(new Dimension(200, 300));
        split.add(this.sp);
        this.contentPane = new JTabbedPane();
        this.contentPane.setBackground(Color.white);
        this.contentPane.setPreferredSize(new Dimension(400, 300));
        split.add(this.contentPane);
        this.add((Component)split, "Center");
    }

    public void setRootElement(Element root) {
        SequenceTreeNode rootNode = new SequenceTreeNode(root);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setLargeModel(true);
        this.sp.setViewportView(this.tree);
        this.selectionListener = new SequenceTreeSelectionHandler();
        this.tree.addTreeSelectionListener(this.selectionListener);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void clear() {
        this.tree.removeTreeSelectionListener(this.selectionListener);
        this.tree.removeAll();
        this.tree.setModel(null);
        this.tree.setSelectionModel(null);
        this.tree.getUI().uninstallUI(this.tree);
        this.sp.removeAll();
        this.treeModel = null;
        this.contentPane.removeAll();
        this.contentPane.getUI().uninstallUI(this.contentPane);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage java SequenceTreeDisplay xmlFile");
            System.exit(0);
        }
        SequenceXMLFetcher fetcher = new SequenceXMLFetcher(args[0]);
        SequenceModel model = new SequenceModel(fetcher);
        Element root = model.getRoot();
        SequenceTreeDisplay treeDisplay = new SequenceTreeDisplay();
        treeDisplay.setRootElement(root);
        JFrame f = new JFrame("Sequence Tree Display");
        f.addWindowListener(new 1());
        f.getContentPane().add((Component)treeDisplay, "Center");
        ((Component)f).setSize(800, 300);
        ((Component)f).setVisible(true);
    }

    static /* synthetic */ void access$1(SequenceTreeDisplay accsParam$0, JTabbedPane accParam$1) {
        accsParam$0.contentPane = accParam$1;
    }

    static /* synthetic */ void access$3(SequenceTreeDisplay accsParam$0, JTree accParam$1) {
        accsParam$0.tree = accParam$1;
    }

    class SequenceTreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            SequenceTreeDisplay.this.contentPane.removeAll();
            TreePath[] paths = SequenceTreeDisplay.this.tree.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            SequenceTreeNode node = null;
            Element seq = null;
            SequenceElementTableView panel = null;
            int i = 0;
            while (i < paths.length) {
                node = (SequenceTreeNode)paths[i].getLastPathComponent();
                seq = node.getSequence();
                panel = new SequenceElementTableView();
                panel.setSequence(seq);
                SequenceTreeDisplay.this.contentPane.addTab(seq.getAttributeValue("name"), panel);
                if (i == paths.length - 1) {
                    SequenceTreeDisplay.this.contentPane.setSelectedComponent(panel);
                }
                ++i;
            }
        }

        SequenceTreeSelectionHandler() {
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

