/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import jadex.swing.sequence.SequenceDisplay;
import jadex.xml.XMLUtilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class SequenceLayoutModel {
    private SequenceDisplay display = null;
    protected float xPadding = 10.0f;
    protected float yPadding = 10.0f;
    protected float distance = 30.0f;
    protected float height = 15.0f;
    private double rel;
    private long offset;
    private int currentH;
    private int currentW;
    private MapRange range = null;
    protected final int ZOOM_STEP = 4;
    private long mouseAt;
    protected int totalLayers = 6;
    protected int IS_UP = 0;
    protected int IS_LOW = 1;
    protected long totalBP;
    protected List boxes = null;
    private Comparator leftSortComp;
    private Comparator rightSortComp;

    public SequenceLayoutModel() {
        this.leftSortComp = new 1();
        this.rightSortComp = new 2();
    }

    public SequenceLayoutModel(SequenceDisplay display) {
        this.leftSortComp = new 3();
        this.rightSortComp = new 4();
        this.display = display;
    }

    public SequenceLayoutModel(int layer, SequenceDisplay display) {
        this.leftSortComp = new 5();
        this.rightSortComp = new 6();
        this.totalLayers = layer;
        this.display = display;
    }

    protected void relayout() {
        if (this.range == null) {
            return;
        }
        Insets insets = this.display.getInsets();
        int w1 = this.display.getWidth();
        float w = (float)w1 - 2.0f * this.xPadding - (float)insets.left - (float)insets.right;
        int h1 = this.display.getHeight();
        if (h1 != this.currentH || w1 != this.currentW) {
            this.currentW = w1;
            this.currentH = h1;
            float y = (float)h1 - this.yPadding - (float)insets.bottom;
            float x = this.xPadding + (float)insets.left;
            if (this.boxes == null) {
                this.boxes = new ArrayList();
            } else {
                this.totalLayers = this.boxes.size();
                this.boxes.clear();
            }
            int i = 0;
            while (i < this.totalLayers) {
                float rectH = 2.0f * this.height;
                if (i == 0) {
                    rectH = this.height;
                }
                this.boxes.add(new Rectangle2D.Float(x, y -= rectH, w, rectH));
                y -= this.distance;
                ++i;
            }
        }
        try {
            long extend = this.range.getExtend();
            this.offset = this.range.getStart();
            this.rel = w / (float)extend;
        }
        catch (UnknownPositionException e) {
            System.out.println("SequenceLayoutModel.relayout(): " + e);
        }
    }

    public void setTotalBP(long total) {
        this.totalBP = total;
        this.setMapRange(new MapRange(1L, total));
    }

    public void setMapRange(MapRange range) {
        MapRange oldValue = this.range;
        this.range = range;
        this.display.repaint();
        this.display.firePropertyChange("range", oldValue, range);
    }

    public MapRange getMapRange() {
        return this.range;
    }

    public Rectangle getBounds(Element sequence, int layer, boolean isOdd) {
        float endX;
        if (sequence == null) {
            return null;
        }
        long[] pos = XMLUtilities.getPositions(sequence, this.display.getModel().getNamespace());
        float startX = this.fromBpToX(pos[0]);
        if (!this.checkIn(startX, endX = this.fromBpToX(pos[1]))) {
            return null;
        }
        if (startX > endX) {
            float x = startX;
            startX = endX;
            endX = x;
        }
        if (startX < -1.0f) {
            startX = -1.0f;
        }
        if (endX > (float)(this.display.getWidth() + 2)) {
            endX = this.display.getWidth() + 2;
        }
        Rectangle2D.Float rect1 = null;
        try {
            rect1 = (Rectangle2D.Float)this.boxes.get(layer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            rect1 = this.createNewLayer(layer);
        }
        float y = (float)rect1.getY();
        if (isOdd) {
            y += this.height;
        }
        return new Rectangle((int)startX, (int)y, (int)(endX - startX), (int)this.height);
    }

    public Rectangle getSequenceAndGeneBounds(Element sequence, int layer, boolean isOdd) {
        Rectangle rect = this.getBounds(sequence, layer, isOdd);
        rect.y = rect.y - (int)this.distance - (int)this.height;
        rect.height = rect.height + (int)this.distance + (int)this.height;
        return rect;
    }

    public Rectangle getGeneBounds(Rectangle rect) {
        Rectangle geneRect = new Rectangle();
        geneRect.x = rect.x;
        geneRect.y = rect.y - (int)this.distance - (int)this.height;
        geneRect.width = rect.width;
        geneRect.height = rect.height;
        return geneRect;
    }

    private Rectangle2D.Float createNewLayer(int layer) {
        Rectangle2D.Float rect0 = (Rectangle2D.Float)this.boxes.get(0);
        float x = rect0.x;
        float y = rect0.y - this.distance * (float)layer - this.height * 2.0f * (float)layer;
        Rectangle2D.Float newRect = new Rectangle2D.Float(x, y, rect0.width, this.height * 2.0f);
        this.boxes.add(newRect);
        return newRect;
    }

    protected float fromBpToX(long bp) {
        return (float)((double)this.xPadding + this.rel * (double)(bp - this.offset));
    }

    protected long fromXtoBp(float x) {
        return this.offset + (long)((double)(x - this.xPadding) / this.rel);
    }

    private boolean checkIn(float startX, float endX) {
        Insets insets = this.display.getInsets();
        float x0 = this.xPadding + (float)insets.left;
        if (startX < x0 && endX < x0) {
            return false;
        }
        int w1 = this.display.getWidth();
        float xm = (float)(w1 - insets.right) - this.xPadding;
        return !(startX > xm) || !(endX > xm);
    }

    public Element getClosestElement(int x, int y) {
        int[] box = this.getBoxFromY(x, y);
        if (box[0] == -1) {
            return null;
        }
        if (box[0] == 0) {
            return this.display.getModel().getRoot();
        }
        long bp = this.fromXtoBp(x);
        return this.searchElement(box, bp);
    }

    protected List getElementsBetween(Rectangle rect) {
        List<Object> list1 = null;
        int box = this.getBoxAboveY((float)rect.getMaxY());
        Element root = this.display.getModel().getRoot();
        if (box == 0) {
            list1 = new ArrayList<Element>();
            list1.add(root);
            return list1;
        }
        long bp1 = this.fromXtoBp(rect.x);
        if (bp1 <= 0L) {
            bp1 = 1L;
        } else if (bp1 > this.totalBP) {
            bp1 = this.totalBP;
        }
        long bp2 = this.fromXtoBp((float)rect.getMaxX());
        if (bp2 <= 0L) {
            bp2 = 1L;
        } else if (bp2 > this.totalBP) {
            bp2 = this.totalBP;
        }
        System.out.println("bp1 " + bp1 + " bp2 " + bp2);
        Element leftEnd = null;
        Element rightEnd = null;
        list1 = XMLUtilities.getSubSequences(root, root.getNamespace());
        int i = 1;
        while (i <= box) {
            leftEnd = this.getElementLeftTo(bp1, list1);
            rightEnd = this.getElementRightTo(bp2, list1);
            list1 = this.getSubListElements(list1, leftEnd, rightEnd);
            ++i;
        }
        return list1;
    }

    private List getSubListElements(List list, Element left, Element right) {
        int index1 = left == null ? 0 : list.indexOf(left);
        int index2 = right == null ? list.size() - 1 : list.indexOf(right);
        List list1 = list.subList(index1, index2 + 1);
        ArrayList total = new ArrayList();
        List l = null;
        Element elm = null;
        Iterator it = list1.iterator();
        while (it.hasNext()) {
            elm = (Element)it.next();
            l = XMLUtilities.getSubSequences(elm, elm.getNamespace());
            if (l == null) continue;
            total.addAll(l);
        }
        return total;
    }

    private Element getElementRightTo(long bp, List list) {
        Collections.sort(list, this.leftSortComp);
        return this.searchRightMostElement(list, bp, 0, list.size());
    }

    private Element searchRightMostElement(List list, long bp, int start, int end) {
        if (start == end) {
            return null;
        }
        int index = (start + end) / 2;
        MapRange range1 = null;
        Element sequence1 = null;
        MapRange range2 = null;
        Element sequence2 = null;
        Object found = null;
        sequence1 = (Element)list.get(index);
        range1 = XMLUtilities.getMapRange(sequence1, sequence1.getNamespace());
        long left1 = this.range.getLeftEnd();
        if (index == 0) {
            if (left1 >= bp) {
                return sequence1;
            }
            return null;
        }
        sequence2 = (Element)list.get(index - 1);
        range2 = XMLUtilities.getMapRange(sequence2, sequence2.getNamespace());
        long left2 = this.range.getLeftEnd();
        if (bp <= left1 && bp > left2) {
            return sequence1;
        }
        if (bp <= left1) {
            return this.searchRightMostElement(list, bp, index + 1, end);
        }
        return this.searchRightMostElement(list, bp, start, index);
    }

    private Element getElementLeftTo(long bp, List list) {
        Collections.sort(list, this.rightSortComp);
        return this.searchLeftMostElement(list, bp, 0, list.size());
    }

    private Element searchLeftMostElement(List list, long bp, int start, int end) {
        if (start == end) {
            return null;
        }
        int index = (start + end) / 2;
        MapRange range1 = null;
        Element sequence1 = null;
        MapRange range2 = null;
        Element sequence2 = null;
        Object found = null;
        sequence1 = (Element)list.get(index);
        range1 = XMLUtilities.getMapRange(sequence1, sequence1.getNamespace());
        long right1 = this.range.getRightEnd();
        if (index == list.size() - 1) {
            if (right1 <= bp) {
                return sequence1;
            }
            return null;
        }
        sequence2 = (Element)list.get(index + 1);
        range2 = XMLUtilities.getMapRange(sequence2, sequence2.getNamespace());
        long right2 = this.range.getRightEnd();
        if (bp >= right1 && bp < right2) {
            return sequence1;
        }
        if (bp >= right1) {
            return this.searchLeftMostElement(list, bp, start, index);
        }
        return this.searchLeftMostElement(list, bp, index + 1, end);
    }

    protected int[] getBoxFromY(float x, float y) {
        int[] rtn = new int[2];
        rtn[0] = -1;
        Iterator i = this.boxes.iterator();
        while (i.hasNext()) {
            Rectangle2D.Float rect = (Rectangle2D.Float)i.next();
            if (!rect.contains(x, y)) continue;
            rtn[0] = this.boxes.indexOf(rect);
            if ((double)y - rect.getY() < (double)this.height) {
                rtn[1] = this.IS_UP;
                break;
            }
            rtn[1] = this.IS_LOW;
            break;
        }
        return rtn;
    }

    protected int getBoxAboveY(float y) {
        int rtn = -1;
        Iterator it = this.boxes.iterator();
        while (it.hasNext()) {
            Rectangle2D.Float rect = (Rectangle2D.Float)it.next();
            if (!(rect.y <= y)) continue;
            rtn = this.boxes.indexOf(rect);
            break;
        }
        return rtn;
    }

    protected int getBoxBelowY(float y) {
        int rtn = -1;
        int i = this.boxes.size() - 1;
        while (i >= 0) {
            Rectangle2D.Float rect = (Rectangle2D.Float)this.boxes.get(i);
            if (rect.getMaxY() >= (double)y) {
                rtn = i;
                break;
            }
            --i;
        }
        return rtn;
    }

    protected Element searchElement(int[] box, long bp) {
        Element root = this.display.getModel().getRoot();
        Namespace ns = this.display.getModel().getNamespace();
        Element sequence = root;
        int i = 1;
        while (i <= box[0]) {
            sequence = i == box[0] ? this.doSearchElement(sequence, ns, bp, box[1]) : this.doSearchElement(sequence, ns, bp);
            ++i;
        }
        return sequence;
    }

    private Element doSearchElement(Element sequence, Namespace ns, long bp) {
        if (sequence == null) {
            return null;
        }
        List list = XMLUtilities.getSubSequences(sequence, ns);
        if (list == null || list.size() == 0) {
            return null;
        }
        int end = list.size();
        return this.checkElement(list, bp, ns, 0, end);
    }

    private Element doSearchElement(Element sequence, Namespace ns, long bp, int upOrLow) {
        if (sequence == null) {
            return null;
        }
        List list = XMLUtilities.getSubSequences(sequence, ns);
        if (list == null || list.size() == 0) {
            return null;
        }
        int end = list.size();
        Element elm = this.checkElement(list, bp, ns, 0, end);
        if (elm == null) {
            return null;
        }
        int index = list.indexOf(elm);
        if (index % 2 == 0 && upOrLow == this.IS_UP) {
            return elm;
        }
        if (index % 2 != 0 && upOrLow == this.IS_LOW) {
            return elm;
        }
        return this.checkNeighbor(list, index, bp, ns);
    }

    private Element checkNeighbor(List list, int index, long bp, Namespace ns) {
        Element right;
        Element left;
        if (index > 0 && this.containsBp(left = (Element)list.get(index - 1), bp, ns)) {
            return left;
        }
        if (index < list.size() - 1 && this.containsBp(right = (Element)list.get(index + 1), bp, ns)) {
            return right;
        }
        return null;
    }

    private boolean containsBp(Element seq, long bp, Namespace ns) {
        MapRange range = XMLUtilities.getMapRange(seq, ns);
        return range.contain(bp);
    }

    private Element checkElement(List list, long bp, Namespace ns, int start, int end) {
        if (end == start) {
            return null;
        }
        int index = (end + start) / 2;
        Element seq = (Element)list.get(index);
        long[] pos = XMLUtilities.getPositions(seq, ns);
        if (pos[0] < pos[1]) {
            if (bp < pos[0]) {
                return this.checkElement(list, bp, ns, start, index);
            }
            if (bp > pos[1]) {
                return this.checkElement(list, bp, ns, index + 1, end);
            }
            return seq;
        }
        if (bp < pos[1]) {
            return this.checkElement(list, bp, ns, start, index);
        }
        if (bp > pos[0]) {
            return this.checkElement(list, bp, ns, index + 1, end);
        }
        return seq;
    }

    public void zoomIn() {
        MapRange newValue = this.range.zoomIn(4);
        this.setMapRange(newValue);
    }

    public void zoomOut() {
        MapRange newValue = this.checkRange(this.range.zoomOut(4));
        this.setMapRange(newValue);
    }

    public void moveLeft() {
        MapRange newValue = this.checkRange(this.range.moveDown(4));
        this.setMapRange(newValue);
    }

    public void moveRight() {
        MapRange newValue = this.checkRange(this.range.moveUp(4));
        this.setMapRange(newValue);
    }

    public void reset() {
        this.setMapRange(new MapRange(1L, this.totalBP));
    }

    public void zoom(Rectangle rect) {
        int x1 = rect.x;
        int x2 = rect.x + rect.width;
        long start = this.fromXtoBp(x1);
        long end = this.fromXtoBp(x2);
        this.setMapRange(new MapRange(start, end));
    }

    private MapRange checkRange(MapRange range) {
        try {
            long end;
            long start = range.getStart();
            if (start < 1L) {
                range.setStart(1L);
            }
            if ((end = range.getEnd()) > this.totalBP) {
                range.setEnd(this.totalBP);
            }
        }
        catch (UnknownPositionException e) {
            System.err.println("SequenceLayoutModel.checkRange(): " + e);
        }
        return range;
    }

    public void setMouseAt(long p) {
        if (this.mouseAt == p) {
            return;
        }
        if (p < 1L) {
            p = 1L;
        }
        if (p > this.totalBP) {
            p = this.totalBP;
        }
        long tmp = this.mouseAt;
        this.mouseAt = p;
        this.display.firePropertyChange("mousePosition", new Long(tmp), new Long(this.mouseAt));
    }

    public long getMouseAt() {
        return this.mouseAt;
    }

    protected void outputSequenceList(List list) {
        Element seq = null;
        MapRange range = null;
        String name = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("List: ");
        Iterator it = list.iterator();
        while (it.hasNext()) {
            seq = (Element)it.next();
            name = seq.getAttributeValue("name");
            buffer.append(name);
            buffer.append(" ");
            range = XMLUtilities.getMapRange(seq, seq.getNamespace());
            try {
                buffer.append(range.getStart() + " ");
                buffer.append(range.getEnd() + " ");
            }
            catch (UnknownPositionException e) {
                System.err.println("SequenceLayoutModel.outputSequenceList(): " + e);
            }
        }
        System.out.println(buffer.toString());
    }

    private final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long left1 = range1.getLeftEnd();
            long left2 = range2.getLeftEnd();
            int rtn = 0;
            if (left1 > left2) {
                rtn = 1;
            } else if (left1 < left2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long right1 = range1.getRightEnd();
            long right2 = range2.getRightEnd();
            int rtn = 0;
            if (right1 > right2) {
                rtn = 1;
            } else if (right1 < right2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long left1 = range1.getLeftEnd();
            long left2 = range2.getLeftEnd();
            int rtn = 0;
            if (left1 > left2) {
                rtn = 1;
            } else if (left1 < left2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long right1 = range1.getRightEnd();
            long right2 = range2.getRightEnd();
            int rtn = 0;
            if (right1 > right2) {
                rtn = 1;
            } else if (right1 < right2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long left1 = range1.getLeftEnd();
            long left2 = range2.getLeftEnd();
            int rtn = 0;
            if (left1 > left2) {
                rtn = 1;
            } else if (left1 < left2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Element seq1 = (Element)o1;
            Element seq2 = (Element)o2;
            MapRange range1 = XMLUtilities.getMapRange(seq1, seq1.getNamespace());
            MapRange range2 = XMLUtilities.getMapRange(seq2, seq2.getNamespace());
            long right1 = range1.getRightEnd();
            long right2 = range2.getRightEnd();
            int rtn = 0;
            if (right1 > right2) {
                rtn = 1;
            } else if (right1 < right2) {
                rtn = -1;
            }
            return rtn;
        }

        /* synthetic */ 6() {
        }
    }
}

