/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.sequence.IndividualSequenceView;
import jadex.swing.sequence.SequenceElementView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdom.Element;

public class SequenceElementTableView
extends JPanel
implements SequenceElementView {
    private JTable table = null;

    public SequenceElementTableView() {
        this.initialize();
    }

    public SequenceElementTableView(Element sequence) {
        this.initialize();
        this.setSequence(sequence);
    }

    private void initialize() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
    }

    public JComponent getSequenceView() {
        return this;
    }

    public void setSequence(Element sequence) {
        SequenceTableModel tableModel = new SequenceTableModel(sequence);
        this.table = new JTable();
        this.table.setRowHeight(225);
        SequenceCellRenderer renderer = new SequenceCellRenderer();
        try {
            this.table.setDefaultRenderer(Class.forName("org.jdom.Element"), renderer);
            this.table.setDefaultEditor(Class.forName("org.jdom.Element"), renderer);
        }
        catch (ClassNotFoundException e) {
            System.err.println("SequenceElementTableView.setSequence(): " + e);
        }
        this.table.setModel(tableModel);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.addJButtonForMore(sequence.getAttributeValue("name"));
    }

    private void addJButtonForMore(String name) {
        JButton button = new JButton("For more information, click this...");
        button.setToolTipText("Link to Wormbase in a new browser window");
        button.addActionListener(new 1(name));
        JPanel p = new JPanel();
        p.add(button);
        this.add((Component)p, "South");
    }

    public JTable getTable() {
        return this.table;
    }

    class SequenceTableModel
    extends AbstractTableModel {
        Element range = null;
        Element gene = null;
        Element remark = null;

        SequenceTableModel(Element sequence) {
            this.parseSequence(sequence);
        }

        private void parseSequence(Element sequence) {
            this.range = this.getCopy(sequence, "Range");
            this.gene = this.getCopy(sequence, "Gene");
            if (this.gene != null) {
                this.remark = this.gene.getChild("Remark", this.gene.getNamespace());
            }
            sequence = null;
        }

        private Element getCopy(Element seq, String name) {
            Element elm = seq.getChild(name, seq.getNamespace());
            if (elm == null) {
                return null;
            }
            return elm.getCopy(name, seq.getNamespace());
        }

        public int getRowCount() {
            return 1;
        }

        public int getColumnCount() {
            if (this.gene == null) {
                return 1;
            }
            if (this.remark == null) {
                return 2;
            }
            return 3;
        }

        public Object getValueAt(int p1, int p2) {
            Element rtn = null;
            switch (p2) {
                case 0: {
                    rtn = this.range;
                    break;
                }
                case 1: {
                    rtn = this.gene.getChild("Exons", this.gene.getNamespace());
                    break;
                }
                case 2: {
                    rtn = this.remark;
                }
            }
            return rtn;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public String getColumnName(int p1) {
            String name = null;
            switch (p1) {
                case 0: {
                    name = "Position";
                    break;
                }
                case 1: {
                    name = "Exons";
                    break;
                }
                case 2: {
                    name = "Remark";
                }
            }
            return name;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    class SequenceCellRenderer
    implements TableCellRenderer,
    TableCellEditor {
        JComponent rangeView;
        JComponent exonView;
        JComponent remarkView;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = null;
            Element elm = (Element)value;
            String elmName = elm.getName();
            comp = elmName.equals("Range") ? this.getRangeView(elm) : (elmName.equals("Exons") ? this.getExonView(elm) : (elmName.equals("Remark") ? this.getRemarkView(elm) : new JLabel(value.toString())));
            return comp;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }

        private JComponent getRangeView(Element range) {
            if (this.rangeView == null) {
                Object[] columnName = new String[]{"Start", "End", "Length"};
                long[] pos = new long[]{Long.parseLong(range.getAttributeValue("start")), Long.parseLong(range.getAttributeValue("end"))};
                long len = pos[1] - pos[0];
                len = len > 0L ? ++len : --len;
                Object[][] data = new Object[][]{{new Long(pos[0]), new Long(pos[1]), new Long(len)}};
                JTable rangeTable = new JTable(data, columnName);
                this.rangeView = new JScrollPane(rangeTable);
            }
            return this.rangeView;
        }

        private JComponent getExonView(Element exons) {
            if (this.exonView == null) {
                Object[] columnName = new String[]{"Exon#", "Start", "End", "Length"};
                List list = exons.getChildren("Exon", exons.getNamespace());
                int size = list.size();
                Object[][] data = new Object[size][columnName.length];
                Element exon = null;
                int i = 0;
                while (i < size) {
                    exon = (Element)list.get(i);
                    data[i][0] = i + 1 + "";
                    data[i][1] = exon.getAttributeValue("start");
                    data[i][2] = exon.getAttributeValue("end");
                    data[i][3] = exon.getAttributeValue("length");
                    ++i;
                }
                JTable table = new JTable(data, columnName);
                this.exonView = new JScrollPane(table);
            }
            return this.exonView;
        }

        private JComponent getRemarkView(Element remark) {
            if (this.remarkView == null) {
                JTextArea tf = new JTextArea();
                tf.setLineWrap(true);
                tf.setWrapStyleWord(true);
                tf.setText(remark.getTextTrim());
                this.remarkView = new JScrollPane(tf);
            }
            return this.remarkView;
        }

        public void cancelCellEditing() {
        }

        public boolean stopCellEditing() {
            return true;
        }

        public boolean shouldSelectCell(EventObject p1) {
            return true;
        }

        public Object getCellEditorValue() {
            return this.exonView;
        }

        public boolean isCellEditable(EventObject p1) {
            return true;
        }

        public void addCellEditorListener(CellEditorListener p1) {
        }

        public void removeCellEditorListener(CellEditorListener p1) {
        }

        SequenceCellRenderer() {
        }
    }

    private final class 1
    implements ActionListener {
        private final /* synthetic */ String val$name;

        public void actionPerformed(ActionEvent e) {
            IndividualSequenceView.showSequenceInDetail(this.val$name);
        }

        /* synthetic */ 1(String val$name) {
            this.val$name = val$name;
        }
    }
}

