/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.sequence.SequenceDisplay;
import jadex.swing.sequence.SequenceSelectionEvent;
import jadex.swing.sequence.SequenceSelectionListener;
import jadex.swing.sequence.SequenceSelectionModel;
import jadex.swing.sequence.SequenceTreeDisplay;
import jadex.swing.sequence.SequenceTreeNode;
import jadex.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;

public class SequenceDisplayAndTreeAdapter
implements TreeSelectionListener,
SequenceSelectionListener {
    private SequenceDisplay display = null;
    private JTree tree = null;
    private TreePath rootPath = null;
    private boolean isDone = false;

    public SequenceDisplayAndTreeAdapter(SequenceDisplay display, SequenceTreeDisplay treeDisplay) {
        this.display = display;
        this.tree = treeDisplay.getTree();
        this.rootPath = this.tree.getPathForRow(0);
        display.getSelectionModel().addSelectionListener(this);
        this.tree.addTreeSelectionListener(this);
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.isDone) {
            this.isDone = false;
            return;
        }
        this.isDone = true;
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.display.clearSelection();
            return;
        }
        SequenceTreeNode node = null;
        Element seq = null;
        ArrayList<Element> sel = new ArrayList<Element>();
        MapRange range = null;
        int i = 0;
        while (i < paths.length) {
            node = (SequenceTreeNode)paths[i].getLastPathComponent();
            seq = node.getSequence();
            range = XMLUtilities.getMapRange(seq, seq.getNamespace()).combine(range);
            sel.add(seq);
            ++i;
        }
        this.display.setSelectedSequences(sel);
        this.display.setMapRange(range);
    }

    public void valueChanged(SequenceSelectionEvent e) {
        if (this.isDone) {
            this.isDone = false;
            return;
        }
        this.isDone = true;
        Object source = e.getSource();
        if (source instanceof SequenceSelectionModel) {
            SequenceSelectionModel sequenceSelectionModel = (SequenceSelectionModel)e.getSource();
            List list = sequenceSelectionModel.getSelection();
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            int size = list.size();
            TreePath[] paths = new TreePath[size];
            int i = 0;
            while (i < size) {
                Element seq = (Element)list.get(i);
                paths[i] = this.constructPath(treeModel.getPathToRoot(new SequenceTreeNode(seq)));
                if (i == size - 1) {
                    this.tree.scrollPathToVisible(paths[i]);
                }
                ++i;
            }
            this.tree.setSelectionPaths(paths);
        }
    }

    private TreePath constructPath(TreeNode[] nodes) {
        TreePath rtnPath = this.rootPath;
        int i = 1;
        while (i < nodes.length) {
            rtnPath = rtnPath.pathByAddingChild(nodes[i]);
            ++i;
        }
        return rtnPath;
    }

    public void clear() {
        this.display.getSelectionModel().removeSelectionListener(this);
        this.tree.removeTreeSelectionListener(this);
        this.display = null;
        this.rootPath = null;
        this.tree = null;
    }
}

