/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.sequence.RangeSpecifyDialog;
import jadex.swing.sequence.SequenceDisplay;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SequenceActions {
    private Action zoom = null;
    private Action zoomIn = null;
    private Action zoomOut = null;
    private Action reset = null;
    private Action moveLeft = null;
    private Action moveRight = null;
    private Action search = null;
    private Action help = null;
    private Action exit = null;
    private Map actions = new HashMap();
    private SequenceDisplay display = null;
    private boolean inApplet = false;
    private final int BIG_ICON = 24;
    private final int SMALL_ICON = 16;
    private int iconSize = 16;
    private static SequenceActions instance = null;

    public static SequenceActions getInstance() {
        if (instance == null) {
            instance = new SequenceActions();
        }
        return instance;
    }

    public static SequenceActions getInstance(boolean inApplet) {
        if (instance == null) {
            instance = new SequenceActions(inApplet);
        }
        return instance;
    }

    private SequenceActions() {
        this.initialize();
    }

    private SequenceActions(boolean inApplet) {
        this.inApplet = inApplet;
        this.initialize();
    }

    private void initialize() {
        this.makeZoomAction();
        this.makeZoomInAction();
        this.makeZoomOutAction();
        this.makeResetAction();
        this.makeMoveLeftAction();
        this.makeMoveRightAction();
        this.makeSearchAction();
        this.makeHelpAction();
        this.makeExitAction();
    }

    public boolean isInApplet() {
        return this.inApplet;
    }

    private void makeZoomAction() {
        ImageIcon icon = this.getIcon("Zoom");
        this.zoom = new 1("Specify a Range", icon);
        this.actions.put("zoom", this.zoom);
    }

    private void makeZoomInAction() {
        ImageIcon icon = this.getIcon("ZoomIn");
        this.zoomIn = new 2("Zoom In", icon);
        this.actions.put("zoomIn", this.zoomIn);
    }

    private void makeZoomOutAction() {
        ImageIcon icon = this.getIcon("ZoomOut");
        this.zoomOut = new 3("Zoom Out", icon);
        this.actions.put("zoomOut", this.zoomOut);
    }

    private void makeResetAction() {
        ImageIcon icon = this.getIcon("Home");
        this.reset = new 4("Reset", icon);
        this.actions.put("reset", this.reset);
    }

    private void makeMoveLeftAction() {
        ImageIcon icon = this.getIcon("Back");
        this.moveLeft = new 5("Move Left", icon);
        this.actions.put("moveLeft", this.moveLeft);
    }

    private void makeMoveRightAction() {
        ImageIcon icon = this.getIcon("Forward");
        this.moveRight = new 6("Move Right", icon);
        this.actions.put("moveRight", this.moveRight);
    }

    private void makeSearchAction() {
        ImageIcon icon = this.getIcon("Search");
        this.search = new 7("Search", icon);
        this.actions.put("search", this.search);
    }

    private void makeHelpAction() {
        ImageIcon icon = this.getIcon("Help");
        this.help = new 8("Help", icon);
        this.actions.put("help", this.help);
    }

    private void makeExitAction() {
        this.exit = new 9("Exit");
        this.actions.put("exit", this.exit);
    }

    private ImageIcon getIcon(String name) {
        ImageIcon icon = null;
        String file = "image/" + name + this.iconSize + ".gif";
        if (!this.inApplet) {
            icon = new ImageIcon(file);
        } else {
            URL url = this.getClass().getResource(file);
            icon = new ImageIcon(url);
        }
        return icon;
    }

    public void setBigIcon() {
        this.iconSize = 24;
        this.initialize();
    }

    public void setSmallIcon() {
        this.iconSize = 16;
        this.initialize();
    }

    public Map getActions() {
        return this.actions;
    }

    public void setSequenceDisplay(SequenceDisplay dis) {
        this.display = dis;
    }

    public void setZoomAction(Action a) {
        this.zoom = a;
    }

    public Action getZoomAction() {
        return this.zoom;
    }

    public void setZoomInAction(Action a) {
        this.zoomIn = a;
    }

    public Action getZoomInAction() {
        return this.zoomIn;
    }

    public void setZoomOutAction(Action a) {
        this.zoomOut = a;
    }

    public Action getZoomOutAction() {
        return this.zoomOut;
    }

    public void setResetAction(Action a) {
        this.reset = a;
    }

    public Action getResetAction() {
        return this.reset;
    }

    public void setMoveLeftAction(Action a) {
        this.moveLeft = a;
    }

    public Action getMoveLeftAction() {
        return this.moveLeft;
    }

    public void setMoveRightAction(Action a) {
        this.moveRight = a;
    }

    public Action getMoveRightAction() {
        return this.moveRight;
    }

    public void setSearchAction(Action a) {
        this.search = a;
    }

    public Action getSearchAction() {
        return this.search;
    }

    public void setHelpAction(Action a) {
        this.help = a;
    }

    public Action getHelpAction() {
        return this.help;
    }

    public void setExitAction(Action exit) {
        this.exit = exit;
    }

    public Action getExitAction() {
        return this.exit;
    }

    static /* synthetic */ void access$1(SequenceActions accsParam$0, SequenceDisplay accParam$1) {
        accsParam$0.display = accParam$1;
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase("range") && SequenceActions.this.display != null) {
                MapRange range = (MapRange)e.getNewValue();
                SequenceActions.this.display.setMapRange(range);
            }
        }

        PropertyChangeHandler() {
        }
    }

    private final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            RangeSpecifyDialog dialog = new RangeSpecifyDialog((Frame)new JFrame(), true);
            dialog.addPropertyChangeListener(new PropertyChangeHandler());
            dialog.show();
        }

        /* synthetic */ 1(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SequenceActions.this.display != null) {
                SequenceActions.this.display.getLayoutModel().zoomIn();
            }
        }

        /* synthetic */ 2(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SequenceActions.this.display != null) {
                SequenceActions.this.display.getLayoutModel().zoomOut();
            }
        }

        /* synthetic */ 3(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SequenceActions.this.display != null) {
                SequenceActions.this.display.getLayoutModel().reset();
            }
        }

        /* synthetic */ 4(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SequenceActions.this.display != null) {
                SequenceActions.this.display.getLayoutModel().moveLeft();
            }
        }

        /* synthetic */ 5(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SequenceActions.this.display != null) {
                SequenceActions.this.display.getLayoutModel().moveRight();
            }
        }

        /* synthetic */ 6(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 7
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            String key = JOptionPane.showInputDialog(SequenceActions.this.display, "Search for ...", "Sequence Search", 3);
            if (key == null || key.length() == 0) {
                return;
            }
            SequenceActions.this.display.search(key);
        }

        /* synthetic */ 7(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            System.out.println("SequenceActions.doHelp");
        }

        /* synthetic */ 8(String p$1, Icon p$2) {
            super(p$1, p$2);
        }
    }

    private final class 9
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }

        /* synthetic */ 9(String p$1) {
            super(p$1);
        }
    }
}

