/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HorizontalMiniMapCartoon
extends JPanel
implements PropertyChangeListener {
    private MapRange range = null;
    private MapRange fullRange = null;
    private Color fullColor = Color.black;
    private Color displayColor = Color.green;
    private float xPadding = 1.0f;
    private float yPadding = 1.0f;

    public HorizontalMiniMapCartoon() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(50, 20));
    }

    public void setFullMapRange(MapRange r) {
        this.range = this.fullRange = r;
        this.repaint();
    }

    public MapRange getFullMapRange() {
        return this.fullRange;
    }

    public void setMapRange(MapRange r) {
        this.range = this.controlRange(r);
        this.repaint();
    }

    public MapRange getMapRange() {
        return this.range;
    }

    private MapRange controlRange(MapRange r) {
        MapRange r1 = null;
        try {
            long start = r.getStart();
            long end = r.getEnd();
            if (start < this.fullRange.getStart()) {
                start = this.fullRange.getStart();
            }
            if (end > this.fullRange.getEnd()) {
                end = this.fullRange.getEnd();
            }
            r1 = new MapRange(start, end);
        }
        catch (UnknownPositionException e) {
            System.err.println("HorizontalMiniMapCartoon.controlRange(): " + e);
        }
        return r;
    }

    public void propertyChange(PropertyChangeEvent p1) {
        if (p1.getPropertyName().equalsIgnoreCase("range")) {
            MapRange r = (MapRange)p1.getNewValue();
            if (this.range != null && r.equals(this.range)) {
                return;
            }
            this.range = r;
            this.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        g2.setPaint(this.getBackground());
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        Insets insets = this.getInsets();
        float width = w - 2.0f * this.xPadding - (float)insets.left - (float)insets.right;
        float height = h / 3.0f;
        float rel = 0.0f;
        if (this.fullRange == null) {
            return;
        }
        try {
            long extend = this.fullRange.getExtend();
            rel = width / (float)extend;
        }
        catch (UnknownPositionException e) {
            System.err.println("HorizonalMiniMapCartoon.paint(): " + e);
        }
        g2.setPaint(this.fullColor);
        float x = (float)insets.left + this.xPadding;
        float y = h / 3.0f;
        g2.fill(new Rectangle2D.Float(x, y, width, height));
        g2.setPaint(this.displayColor);
        float x1 = 0.0f;
        float x2 = 0.0f;
        float w1 = 0.0f;
        try {
            x1 = rel * (float)(this.range.getStart() - 1L);
            x2 = rel * (float)(this.range.getEnd() - 1L);
            w1 = x2 - x1;
            if (w1 < 1.0f) {
                w1 = 1.0f;
            }
        }
        catch (UnknownPositionException e) {
            System.err.println("HorizontalMiniMapCartoon.paintCurrentRange(): " + e);
        }
        g2.fill(new Rectangle2D.Float(x + x1, y, w1, height));
    }
}

