/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HorizontalMapScale
extends JPanel
implements PropertyChangeListener {
    private MapRange range = null;
    private long extend;
    private long start;
    private int TOTAL_TICK = 10;
    private Font labelFont = new Font("Dialog", 0, 9);
    private float xPadding;

    public HorizontalMapScale() {
        this.initialize();
    }

    public HorizontalMapScale(MapRange range) {
        this.initialize();
        this.setRange(range);
    }

    private void initialize() {
        this.xPadding = 10.0f;
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setRange(MapRange range) {
        this.range = range;
        try {
            this.start = range.getStart();
            this.extend = range.getExtend();
            this.repaint();
        }
        catch (UnknownPositionException e) {
            System.err.println("HorizontalMapScale.setMapRange(): " + e);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equalsIgnoreCase("range")) {
            MapRange newRange = (MapRange)e.getNewValue();
            this.setRange(newRange);
        }
    }

    public MapRange getRange() {
        return this.range;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        float w = (float)((Dimension2D)d).getWidth();
        float h = (float)((Dimension2D)d).getHeight();
        Insets insets = this.getInsets();
        g2.setPaint(this.getBackground());
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        float startX = this.xPadding + (float)insets.left;
        float endX = w - this.xPadding - (float)insets.right;
        float y = h - h / 6.0f;
        g2.setPaint(this.getForeground());
        g2.draw(new Line2D.Float(startX, y, endX, y));
        float xPos = startX;
        float diff = (w - (float)insets.left - (float)insets.right - 2.0f * this.xPadding) / (float)this.TOTAL_TICK;
        g2.setFont(this.labelFont);
        FontRenderContext fontContext = g2.getFontRenderContext();
        NumberFormat format = NumberFormat.getNumberInstance();
        int i = 0;
        while (i <= this.TOTAL_TICK) {
            g2.draw(new Line2D.Float(xPos, y, xPos, y - h / 3.0f));
            float sX = xPos;
            if (i < this.TOTAL_TICK) {
                int j = 0;
                while (j < 9) {
                    g2.draw(new Line2D.Float(sX += diff / 10.0f, y, sX, y - h / 12.0f));
                    ++j;
                }
            }
            this.drawLabel(xPos, y - h / 3.0f, g2, i, fontContext, format);
            xPos += diff;
            ++i;
        }
    }

    private void drawLabel(float posx, float posy, Graphics2D g2, int number, FontRenderContext fontContext, NumberFormat format) {
        long diff = this.extend / (long)this.TOTAL_TICK;
        long label = this.start + (long)number * diff;
        String labelS = format.format(label);
        Rectangle2D rect2 = this.labelFont.getStringBounds(labelS, fontContext);
        float x = posx - (float)rect2.getWidth() / 2.0f;
        g2.drawString(labelS, x, posy);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("MapScale Test");
        f.addWindowListener(new 1());
        HorizontalMapScale p = new HorizontalMapScale();
        p.setPreferredSize(new Dimension(1204, 25));
        p.setRange(new MapRange(1L, 1000000L));
        JPanel blank = new JPanel();
        f.getContentPane().add((Component)blank, "Center");
        f.getContentPane().add((Component)p, "South");
        ((Component)f).setSize(1204, 150);
        ((Component)f).setVisible(true);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

