/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jdom.Namespace;

public class GeneRenderer
extends JComponent {
    private Color background = null;
    private Color foreground = Color.yellow;
    private List exons = null;
    private float xPadding = 1.0f;
    private float yPadding = 1.0f;
    private long totalBp;

    public GeneRenderer() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(null);
    }

    public JComponent getGeneRenderer(Element gene, JComponent display, long length) {
        this.background = display.getBackground();
        this.totalBp = length;
        this.constructExons(gene);
        return this;
    }

    private void constructExons(Element gene) {
        Namespace ns = gene.getNamespace();
        Element exonsElement = gene.getChild("Exons", ns);
        this.exons = exonsElement.getChildren("Exon", ns);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d2 = this.getSize();
        Insets insets = this.getInsets();
        float w = (float)((Dimension2D)d2).getWidth();
        float h = (float)((Dimension2D)d2).getHeight();
        float rel = (w - 2.0f * this.xPadding - (float)insets.left - (float)insets.right) / (float)this.totalBp;
        float startX = this.xPadding + (float)insets.left;
        if (this.totalBp < 0L) {
            startX = w - this.xPadding - (float)insets.right;
        }
        g2.setPaint(this.background);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, w, h));
        Element exon = null;
        g2.setPaint(this.foreground);
        float exonX1 = -1.0f;
        float[] pos = new float[]{-1.0f, -1.0f};
        int size = this.exons.size();
        int i = 0;
        while (i < size) {
            exon = (Element)this.exons.get(i);
            exonX1 = pos[1];
            pos = this.paintExon(exon, g2, rel, startX, h);
            if (i != 0) {
                this.paintIntron(g2, exonX1, pos[0], h);
            }
            ++i;
        }
    }

    private float[] paintExon(Element exon, Graphics2D g2, float rel, float startX, float h) {
        String start = exon.getAttributeValue("start");
        String end = exon.getAttributeValue("end");
        int s = Integer.parseInt(start);
        int e = Integer.parseInt(end);
        float x1 = startX + (float)s * rel;
        float x2 = startX + (float)e * rel;
        if (rel > 0.0f) {
            g2.fill(new Rectangle2D.Float(x1, h / 3.0f, x2 - x1, h / 3.0f));
        } else {
            g2.fill(new Rectangle2D.Float(x2, h / 3.0f, x1 - x2, h / 3.0f));
        }
        return new float[]{x1, x2};
    }

    private void paintIntron(Graphics2D g2, float exonX1, float exonX2, float h) {
        float mid = (exonX1 + exonX2) / 2.0f;
        g2.draw(new Line2D.Float(exonX1, h / 2.0f, mid, h / 6.0f));
        g2.draw(new Line2D.Float(exonX2, h / 2.0f, mid, h / 6.0f));
    }
}

