/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.MapRange;
import jadex.swing.sequence.Clone;
import jadex.swing.sequence.CloneFetcher;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileCloneFetcher
extends CloneFetcher {
    private String file = null;

    public FileCloneFetcher() {
    }

    public FileCloneFetcher(String file) {
        this.setFile(file);
    }

    public void setFile(String f) {
        this.file = f;
    }

    public String getCloneInfor() {
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.file));
            }
            catch (Exception exception) {
                InputStream in = this.getClass().getResourceAsStream(this.file);
                reader = new BufferedReader(new InputStreamReader(in));
            }
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            System.err.println("FileCloneFetcher.getCloneInfor(): " + e);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        MapRange r;
        Map ctg;
        if (args.length != 1) {
            System.out.println("Provide a file name");
            System.exit(0);
        }
        String file = args[0];
        FileCloneFetcher fetcher = new FileCloneFetcher(file);
        long start = System.currentTimeMillis();
        fetcher.fetchClone();
        long end = System.currentTimeMillis();
        System.out.println("Time used to processing the data: " + (end - start));
        Map map = fetcher.getClone();
        if (map != null) {
            Set keys = map.keySet();
            String name = null;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                Clone clone = (Clone)map.get(name);
                System.out.println(clone.toString());
            }
        }
        if ((ctg = fetcher.getContig()) != null) {
            System.out.println("Contig number: " + ctg.size());
        }
        if ((r = fetcher.getMapScale()) != null) {
            System.out.println("Map extent: " + r.toString());
        }
    }
}

