/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jadex.swing.map.DisplayControl;
import jadex.swing.map.DisplayModel;
import jadex.swing.map.LocusUI;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapPointDisplay;
import jadex.swing.map.MapRange;
import jadex.swing.sequence.Clone;
import jadex.swing.sequence.CloneDisplay;
import jadex.swing.sequence.CloneFetcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloneControl
extends DisplayControl {
    private CloneDisplay display = null;
    private CloneFetcher fetcher = null;
    private List assignedClones = null;
    private boolean debug = false;

    public CloneControl() {
    }

    public CloneControl(CloneDisplay view) {
        this.setCloneDisplay(view);
    }

    public CloneControl(CloneDisplay view, CloneFetcher fetcher) {
        this.setCloneDisplay(view);
        this.setCloneFetcher(fetcher);
    }

    public CloneControl(CloneDisplay view, DisplayModel model) {
        this.setCloneDisplay(view);
        this.setModel(model);
    }

    public void setCloneDisplay(CloneDisplay view) {
        this.display = view;
    }

    public void setCloneFetcher(CloneFetcher f) {
        this.fetcher = f;
        Map map = this.fetcher.getClone();
        if (map != null) {
            DisplayModel model = new DisplayModel();
            this.setModel(model);
            Set keys = map.keySet();
            String name = null;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                name = (String)iterator.next();
                Clone clone = (Clone)map.get(name);
                model.addPoint((MapPoint)clone);
                if (!this.debug) continue;
                System.out.println(clone.toString());
            }
        }
        this.setTotalMapRange(f.getMapScale());
    }

    public List getClones() {
        return Arrays.asList(this.getModel().getData());
    }

    public List getAssignedClones() {
        if (this.assignedClones == null) {
            this.assignClones(this.getClones());
        }
        return this.assignedClones;
    }

    protected void assignClones(List list) {
        this.assignedClones = new ArrayList();
        ArrayList first = new ArrayList();
        this.assignedClones.add(first);
        Clone clone = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            clone = (Clone)iter.next();
            if (this.add(this.assignedClones, clone)) continue;
            ArrayList<Clone> more = new ArrayList<Clone>();
            more.add(clone);
            this.assignedClones.add(more);
        }
    }

    private boolean add(List list, Clone clone) {
        boolean rtn = false;
        MapRange range = clone.getMapRange();
        Iterator it1 = list.iterator();
        while (it1.hasNext()) {
            List l = (List)it1.next();
            boolean inter = false;
            Iterator it2 = l.iterator();
            while (it2.hasNext()) {
                Clone aCln = (Clone)it2.next();
                MapRange range1 = aCln.getMapRange();
                if (!range.intersect(range1)) continue;
                inter = true;
                break;
            }
            if (inter) continue;
            l.add(clone);
            rtn = true;
            break;
        }
        return rtn;
    }

    public MapPointDisplay getDisplay() {
        return this.display;
    }

    protected void resetUI() {
        int size = this.showNumber <= this.tPoints.length ? this.showNumber : this.tPoints.length;
        this.sPoints = new MapPoint[size];
        this.sLoci = new LocusUI[size];
        Clone tmp = null;
        int i = 0;
        while (i < size) {
            this.sPoints[i] = this.tPoints[i];
            this.sLoci[i] = new LocusUI(this.tPoints[i]);
            tmp = (Clone)this.tPoints[i];
            this.sLoci[i].setToolTipText(String.valueOf(tmp.getName()) + " " + tmp.getMapRange());
            ++i;
        }
        if (this.pattern != null) {
            this.doSearch(this.pattern);
        } else {
            this.updateUI();
        }
    }

    public void updateUI() {
        if (this.display != null) {
            this.display.setShowNames(this.sLoci);
            this.display.repaint();
            if (this.display.getPopup() != null) {
                this.display.getPopup().checkShowMenu();
            }
        }
    }
}

