/*
 * Decompiled with CFR 0.152.
 */
package jadex.swing.sequence;

import jade.db.AceObject;
import jadex.swing.map.MapPoint;
import jadex.swing.map.MapRange;
import jadex.swing.map.UnknownPositionException;
import jadex.swing.sequence.Contig;

public class Clone
implements MapPoint {
    private AceObject obj = null;
    private String name = null;
    private float pos;
    private MapRange range = null;
    private MapRange pmap = null;
    private Contig contig = null;

    public Clone() {
    }

    public Clone(String n) {
        this.setName(n);
    }

    public Clone(String n, MapRange r) {
        this.setName(n);
        this.setMapRange(r);
    }

    public Clone(String n, MapRange r, Contig ctg) {
        this.setContig(ctg);
        this.setName(n);
        this.setPMap(r);
    }

    public String getName() {
        return this.name;
    }

    public MapRange getMapRange() {
        return this.range;
    }

    public float getPosition() throws UnknownPositionException {
        return this.pos;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMapRange(MapRange r) {
        this.range = r;
        try {
            float start = r.getStartF();
            float end = r.getEndF();
            float pos = (start + end) / 2.0f;
            this.setPosition(pos);
        }
        catch (UnknownPositionException e) {
            System.err.println("Clone.setMapRange(): " + e);
        }
    }

    public void setPMap(MapRange r) {
        this.pmap = r;
        if (this.contig != null) {
            this.setMapRange(this.contig.getRangeFromPMap(this.pmap));
        }
    }

    public void setPosition(float position) {
        this.pos = position;
    }

    public void setContig(Contig ctg) {
        this.contig = ctg;
    }

    public void setError(float err) {
    }

    public float getError() {
        return 0.0f;
    }

    public void setAceObject(AceObject o) {
        this.obj = o;
    }

    public AceObject getAceObject() {
        return this.obj;
    }

    public boolean equals(Clone another) {
        String aName = another.getName();
        return this.name.equalsIgnoreCase(aName);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null) {
            buf.append("Name: Clone : " + this.name + "\n");
        }
        if (this.range != null) {
            buf.append("Range: " + this.range + "\n");
        }
        buf.append("Pos: " + this.pos + "\n");
        if (this.contig != null) {
            buf.append("Contig: " + this.contig.getName() + "\n");
        }
        return buf.toString();
    }
}

